/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import optiTrack.MocapDataClient;
import optiTrack.MocapRigidBody;
import optiTrack.MocapRigidbodiesListener;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.time.CallFrequencyCalculator;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.publisher.RosTf2Publisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;
import us.ihmc.yoVariables.registry.YoRegistry;

public class RosMocapPublisher
implements MocapRigidbodiesListener,
Runnable {
    private YoRegistry registry = new YoRegistry("MOCAP");
    private CallFrequencyCalculator frequencyCalculator = new CallFrequencyCalculator(this.registry, "");
    RosMainNode mainNode;
    RosTf2Publisher tfPublisher;

    public RosMocapPublisher() {
        try {
            this.mainNode = new RosMainNode(new URI("http://172.16.66.102:11311"), this.getClass().getSimpleName());
            this.tfPublisher = new RosTf2Publisher(false);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        MocapDataClient mocapDataClient = new MocapDataClient();
        mocapDataClient.registerRigidBodiesListener((MocapRigidbodiesListener)this);
    }

    public void updateRigidbodies(ArrayList<MocapRigidBody> listOfRigidbodies) {
        if (!this.mainNode.isStarted()) {
            return;
        }
        for (MocapRigidBody rigidBody : listOfRigidbodies) {
            RigidBodyTransform tmpTransform = new RigidBodyTransform();
            tmpTransform.getTranslation().set((double)rigidBody.xPosition, (double)rigidBody.yPosition, (double)rigidBody.zPosition);
            tmpTransform.getRotation().set((Orientation3DReadOnly)new Quaternion((double)rigidBody.qx, (double)rigidBody.qy, (double)rigidBody.qz, (double)rigidBody.qw));
            this.tfPublisher.publish(tmpTransform, this.mainNode.getCurrentTime().totalNsecs(), "/mocap_world", "mocap/rigidBody" + rigidBody.getId());
        }
    }

    @Override
    public void run() {
        this.mainNode.attachPublisher("/tf", (RosTopicPublisher)this.tfPublisher);
        this.mainNode.execute();
    }

    public static void main(String[] arg) throws URISyntaxException {
        RosMocapPublisher publisher = new RosMocapPublisher();
        new Thread(publisher).start();
    }
}

