/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import controller_msgs.msg.dds.IntrinsicParametersMessage;
import org.ros.message.Time;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.communication.net.ObjectCommunicator;
import us.ihmc.communication.net.ObjectConsumer;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.LocalVideoPacket;
import us.ihmc.sensorProcessing.parameters.AvatarRobotCameraParameters;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.publisher.RosCameraInfoPublisher;
import us.ihmc.utilities.ros.publisher.RosImagePublisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;

public class RosSCSCameraPublisher
implements ObjectConsumer<LocalVideoPacket> {
    private final RosImagePublisher[] cameraPublisher;
    private final RosMainNode rosMainNode;
    private final RobotROSClockCalculator rosClockCalculator;
    private final AvatarRobotCameraParameters[] cameraParameters;
    private final RosCameraInfoPublisher[] cameraInfoPublishers;
    private final int nSensors;

    public RosSCSCameraPublisher(ObjectCommunicator localObjectCommunicator, RosMainNode rosMainNode, RobotROSClockCalculator rosClockCalculator, AvatarRobotCameraParameters[] cameraParameters) {
        this.nSensors = cameraParameters.length;
        this.rosMainNode = rosMainNode;
        this.rosClockCalculator = rosClockCalculator;
        this.cameraParameters = cameraParameters;
        this.cameraPublisher = new RosImagePublisher[this.nSensors];
        this.cameraInfoPublishers = new RosCameraInfoPublisher[this.nSensors];
        for (int sensorId = 0; sensorId < this.nSensors; ++sensorId) {
            this.cameraPublisher[sensorId] = new RosImagePublisher();
            String imageTopic = cameraParameters[sensorId].getRosTopic();
            rosMainNode.attachPublisher(imageTopic, (RosTopicPublisher)this.cameraPublisher[sensorId]);
            if (cameraParameters[sensorId].getRosCameraInfoTopicName() == null || cameraParameters[sensorId].getRosCameraInfoTopicName() == "") continue;
            String infoTopic = cameraParameters[sensorId].getRosCameraInfoTopicName();
            this.cameraInfoPublishers[sensorId] = new RosCameraInfoPublisher();
            rosMainNode.attachPublisher(infoTopic, (RosTopicPublisher)this.cameraInfoPublishers[sensorId]);
        }
        localObjectCommunicator.attachListener(LocalVideoPacket.class, (ObjectConsumer)this);
    }

    public void consumeObject(LocalVideoPacket object) {
        if (this.rosMainNode.isStarted()) {
            int sensorId = 0;
            long timestamp = this.rosClockCalculator.computeROSTime(object.getTimeStamp(), object.getTimeStamp());
            Time time = Time.fromNano((long)timestamp);
            String frameId = this.cameraParameters[sensorId].getPoseFrameForSdf();
            this.cameraPublisher[sensorId].publish(frameId, object.getImage(), time);
            this.sendIntrinsicPacket(object, sensorId, frameId, time);
        }
    }

    public void sendIntrinsicPacket(LocalVideoPacket videoObject, int sensorId, String frameId, Time time) {
        if (this.cameraInfoPublishers[sensorId] == null) {
            return;
        }
        this.cameraInfoPublishers[sensorId].publish(frameId, HumanoidMessageTools.toIntrinsicParameters((IntrinsicParametersMessage)videoObject.getIntrinsicParameters()), time);
    }
}

