/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.publisher.RosTf1Publisher;
import us.ihmc.utilities.ros.publisher.RosTf2Publisher;
import us.ihmc.utilities.ros.publisher.RosTfPublisherInterface;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;

public class RosTfPublisher
implements RosTfPublisherInterface {
    private final RosTfPublisherInterface tfPublisher;
    private final String tfPrefix;

    public RosTfPublisher(RosMainNode rosMainNode, String tfPrefix) {
        if (tfPrefix == null) {
            this.tfPrefix = "";
        } else if (tfPrefix.equals("NONE")) {
            this.tfPrefix = "";
            PrintTools.info((String)"tfPrefix option set to NONE - using no prefix");
        } else {
            if (tfPrefix.length() > 1 && !tfPrefix.endsWith("/")) {
                tfPrefix = tfPrefix + "/";
            }
            this.tfPrefix = tfPrefix;
            PrintTools.info((String)("tfPrefix: " + this.tfPrefix));
        }
        if (rosMainNode.isUseTf2()) {
            this.tfPublisher = new RosTf2Publisher(false);
            rosMainNode.attachPublisher("/tf", (RosTopicPublisher)((RosTf2Publisher)this.tfPublisher));
        } else {
            this.tfPublisher = new RosTf1Publisher(false);
            rosMainNode.attachPublisher("/tf", (RosTopicPublisher)((RosTf1Publisher)this.tfPublisher));
        }
    }

    public void publish(RigidBodyTransform transform3d, long timeStamp, String parentFrame, String childFrame) {
        if (this.tfPrefix.length() > 0) {
            this.tfPublisher.publish(transform3d, timeStamp, this.tfPrefix + parentFrame, this.tfPrefix + childFrame);
        } else {
            this.tfPublisher.publish(transform3d, timeStamp, parentFrame, childFrame);
        }
    }
}

