/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.concurrent.atomic.AtomicLong;
import us.ihmc.avatar.ros.RobotROSClockCalculator;

public class WallTimeBasedROSClockCalculator
implements RobotROSClockCalculator {
    private final AtomicLong currentTimestampOffset = new AtomicLong(-1L);

    @Override
    public void receivedRobotConfigurationData(RobotConfigurationData robotConfigurationData) {
        this.currentTimestampOffset.set(robotConfigurationData.getWallTime() - robotConfigurationData.getMonotonicTime());
    }

    @Override
    public long computeROSTime(long wallTime, long monotonicTime) {
        return wallTime;
    }

    @Override
    public long computeRobotMonotonicTime(long rosTime) {
        if (this.currentTimestampOffset.get() == -1L) {
            return -1L;
        }
        return rosTime - this.currentTimestampOffset.get();
    }
}

