/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros.messages;

import java.nio.LongBuffer;

public class ClockMessage {
    private long secs;
    private long nsecs;

    public void setFromBuffer(LongBuffer buffer) {
        buffer.rewind();
        this.secs = buffer.get();
        this.nsecs = buffer.get();
    }

    public void packTime(long[] time) {
        if (time.length < 2) {
            throw new RuntimeException("Array for packing time not large enough");
        }
        time[0] = this.secs;
        time[1] = this.nsecs;
    }

    public long secs() {
        return this.secs;
    }

    public long nsecs() {
        return this.nsecs;
    }

    public long toNSecs() {
        return this.secs * 1000000000L + this.nsecs;
    }

    public void setSecs(long secs) {
        this.secs = secs;
    }

    public void setNSecs(long nsecs) {
        this.nsecs = nsecs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[TimeMessage] Secs: " + this.secs);
        builder.append("[TimeMessage} NSecs: " + this.nsecs);
        return builder.toString();
    }
}

