/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros2.networkTest;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import us.ihmc.avatar.ros2.networkTest.SSHJRemoteConnection;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;

public class RemoteSSHTools {
    public static void session(String address, String username, String password, Consumer<SSHJRemoteConnection> action) {
        ExceptionTools.handle(() -> RemoteSSHTools.session(address, (SSHClient sshClient) -> ExceptionTools.handle(() -> sshClient.authPassword(username, password), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION), action), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
    }

    public static void session(String address, String username, Consumer<SSHJRemoteConnection> action) {
        ExceptionTools.handle(() -> RemoteSSHTools.session(address, (SSHClient sshClient) -> RemoteSSHTools.authWithSSHKey(username, sshClient), action), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
    }

    private static void authWithSSHKey(String username, SSHClient sshClient) {
        Path userSSHConfigFolder = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ssh");
        Stream list = (Stream)ExceptionTools.handle(() -> Files.list(userSSHConfigFolder), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
        ArrayList<String> privateKeyFiles = new ArrayList<String>();
        for (Path path : list.collect(Collectors.toList())) {
            if (!Files.isRegularFile(path, new LinkOption[0]) || path.getFileName().toString() == "config" || path.getFileName().toString() == "known_hosts" || path.getFileName().toString().endsWith(".pub")) continue;
            String absoluteNormalizedString = path.toAbsolutePath().normalize().toString();
            privateKeyFiles.add(absoluteNormalizedString);
        }
        LogTools.info((String)"Passing keys to authPublicKey: {}", privateKeyFiles);
        ExceptionTools.handle(() -> sshClient.authPublickey(username, privateKeyFiles.toArray(new String[0])), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void session(String address, Consumer<SSHClient> authenticate, Consumer<SSHJRemoteConnection> action) throws IOException {
        SSHClient sshClient = new SSHClient();
        ExceptionTools.handle(() -> sshClient.loadKnownHosts(), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
        sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        ExceptionTools.handle(() -> sshClient.connect(address), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
        try {
            authenticate.accept(sshClient);
            try (SFTPClient sftpClient = sshClient.newSFTPClient();){
                action.accept(new SSHJRemoteConnection(sshClient, sftpClient));
            }
        }
        finally {
            sshClient.disconnect();
        }
    }
}

