/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros2.networkTest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.SFTPClient;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;

public class SSHJRemoteConnection {
    private SSHClient ssh;
    private SFTPClient sftp;

    public SSHJRemoteConnection(SSHClient ssh, SFTPClient sftp) {
        this.ssh = ssh;
        this.sftp = sftp;
    }

    public void exec(String command) {
        this.exec(command, 5.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(String command, double timeout) {
        Session session = null;
        try {
            session = (Session)ExceptionTools.handle(() -> this.ssh.startSession(), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
            LogTools.info((String)"Executing on {}: {}", (Object)this.ssh.getRemoteHostname(), (Object)command);
            Session finalSession = session;
            Session.Command sshjCommand = (Session.Command)ExceptionTools.handle(() -> finalSession.exec(command), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
            LogTools.info((String)((ByteArrayOutputStream)ExceptionTools.handle(() -> IOUtils.readFully((InputStream)sshjCommand.getInputStream()), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION)).toString());
            LogTools.error((String)((ByteArrayOutputStream)ExceptionTools.handle(() -> IOUtils.readFully((InputStream)sshjCommand.getErrorStream()), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION)).toString());
            ExceptionTools.handle(() -> sshjCommand.join((long)(timeout * 1.0E9), TimeUnit.NANOSECONDS), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
            LogTools.info((String)"** exit status: {}", (Object)sshjCommand.getExitStatus());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void put(String source, String dest) {
        LogTools.info((String)"Putting $source to ${ssh.remoteHostname}:$dest");
        ExceptionTools.handle(() -> this.sftp.put(source, dest), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
    }

    void get(String source, String dest) {
        LogTools.info((String)"Getting ${ssh.remoteHostname}:$source to $dest");
        ExceptionTools.handle(() -> this.sftp.get(source, dest), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
    }
}

