/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.rosAPI;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.ControllerCrashNotificationPacket;
import controller_msgs.msg.dds.HighLevelStateChangeStatusMessage;
import controller_msgs.msg.dds.InvalidPacketNotificationPacket;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ros.internal.message.Message;
import org.ros.message.MessageFactory;
import org.ros.node.NodeConfiguration;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.ros.IHMCPacketToMsgPublisher;
import us.ihmc.avatar.ros.IHMCROSTranslationRuntimeTools;
import us.ihmc.avatar.ros.PeriodicRosHighLevelStatePublisher;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.avatar.ros.RosCapturabilityBasedStatusPublisher;
import us.ihmc.avatar.ros.RosRobotConfigurationDataPublisher;
import us.ihmc.avatar.ros.RosSCSCameraPublisher;
import us.ihmc.avatar.ros.RosSCSLidarPublisher;
import us.ihmc.avatar.ros.subscriber.IHMCMsgToPacketSubscriber;
import us.ihmc.avatar.ros.subscriber.RequestControllerStopSubscriber;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.net.ObjectCommunicator;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.PacketDestination;
import us.ihmc.communication.ros.generators.RosMessagePacket;
import us.ihmc.humanoidRobotics.communication.subscribers.HumanoidRobotDataReceiver;
import us.ihmc.ihmcPerception.IHMCProntoRosLocalizationUpdateSubscriber;
import us.ihmc.ihmcPerception.RosLocalizationPoseCorrectionSubscriber;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.sensorProcessing.parameters.AvatarRobotLidarParameters;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosNodeInterface;
import us.ihmc.utilities.ros.msgToPacket.converter.GenericROSTranslationTools;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class ThePeoplesGloriousNetworkProcessor {
    private static final String nodeName = "/controller";
    private final RobotROSClockCalculator rosClockCalculator;
    private final RosMainNode rosMainNode;
    private final PacketCommunicator controllerCommunicationBridge;
    private final ObjectCommunicator scsSensorCommunicationBridge;
    private final ArrayList<AbstractRosTopicSubscriber<?>> subscribers;
    private final ArrayList<RosTopicPublisher<?>> publishers;
    private final NodeConfiguration nodeConfiguration;
    private final MessageFactory messageFactory;
    private final FullHumanoidRobotModel fullRobotModel;

    public ThePeoplesGloriousNetworkProcessor(URI rosUri, PacketCommunicator controllerCommunicationBridge, DRCRobotModel robotModel, String namespace, String tfPrefix, String ... additionalMessagePackages) throws IOException {
        this(rosUri, controllerCommunicationBridge, null, robotModel.getROSClockCalculator(), robotModel, namespace, tfPrefix, Collections.emptySet(), additionalMessagePackages);
    }

    public ThePeoplesGloriousNetworkProcessor(URI rosUri, PacketCommunicator controllerCommunicationBridge, DRCRobotModel robotModel, String namespace, String tfPrefix, Collection<Class> additionalPacketTypes, String ... additionalMessagePackages) throws IOException {
        this(rosUri, controllerCommunicationBridge, null, robotModel.getROSClockCalculator(), robotModel, namespace, tfPrefix, additionalPacketTypes, additionalMessagePackages);
    }

    public ThePeoplesGloriousNetworkProcessor(URI rosUri, PacketCommunicator rosAPI_communicator, ObjectCommunicator sensorCommunicator, RobotROSClockCalculator ppsOffsetProvider, DRCRobotModel robotModel, String namespace, String tfPrefix, Collection<Class> additionalPacketTypes, String ... additionalMessagePackages) throws IOException {
        this(rosUri, rosAPI_communicator, sensorCommunicator, robotModel.getROSClockCalculator(), robotModel, namespace, tfPrefix, additionalPacketTypes, (List<Map.Entry<String, RosTopicSubscriberInterface<? extends Message>>>)null, (List<Map.Entry<String, RosTopicPublisher<? extends Message>>>)null, additionalMessagePackages);
    }

    public ThePeoplesGloriousNetworkProcessor(URI rosUri, PacketCommunicator rosAPI_communicator, ObjectCommunicator sensorCommunicator, RobotROSClockCalculator rosClockCalculator, DRCRobotModel robotModel, String namespace, String tfPrefix, Collection<Class> additionalPacketTypes, List<Map.Entry<String, RosTopicSubscriberInterface<? extends Message>>> customSubscribers, List<Map.Entry<String, RosTopicPublisher<? extends Message>>> customPublishers, String ... additionalMessagePackages) throws IOException {
        this.rosMainNode = new RosMainNode(rosUri, namespace + nodeName);
        this.controllerCommunicationBridge = rosAPI_communicator;
        this.scsSensorCommunicationBridge = sensorCommunicator;
        this.rosClockCalculator = rosClockCalculator;
        this.rosClockCalculator.subscribeToROS1Topics((RosNodeInterface)this.rosMainNode);
        this.subscribers = new ArrayList();
        this.publishers = new ArrayList();
        this.nodeConfiguration = NodeConfiguration.newPrivate();
        this.messageFactory = this.nodeConfiguration.getTopicMessageFactory();
        this.fullRobotModel = robotModel.createFullRobotModel();
        HumanoidRobotDataReceiver robotDataReceiver = new HumanoidRobotDataReceiver(this.fullRobotModel, null);
        rosAPI_communicator.attachListener(RobotConfigurationData.class, (PacketConsumer)robotDataReceiver);
        rosAPI_communicator.attachListener(RobotConfigurationData.class, rosClockCalculator::receivedRobotConfigurationData);
        rosAPI_communicator.attachListener(HighLevelStateChangeStatusMessage.class, (PacketConsumer)new PeriodicRosHighLevelStatePublisher(this.rosMainNode, namespace));
        rosAPI_communicator.attachListener(CapturabilityBasedStatus.class, (PacketConsumer)new RosCapturabilityBasedStatusPublisher(this.rosMainNode, namespace));
        this.setupInputs(namespace, robotDataReceiver, this.fullRobotModel, additionalMessagePackages);
        this.setupOutputs(namespace, tfPrefix, additionalMessagePackages);
        this.setupRosLocalization();
        if (customSubscribers != null) {
            for (Map.Entry<String, RosTopicSubscriberInterface<? extends Message>> entry : customSubscribers) {
                this.subscribers.add((AbstractRosTopicSubscriber)entry.getValue());
                this.rosMainNode.attachSubscriber(entry.getKey(), entry.getValue());
            }
        }
        if (customPublishers != null) {
            for (Map.Entry<String, RosTopicSubscriberInterface<? extends Message>> entry : customPublishers) {
                this.publishers.add((RosTopicPublisher<?>)entry.getValue());
                this.rosMainNode.attachPublisher(entry.getKey(), (RosTopicPublisher)entry.getValue());
            }
        }
        this.rosMainNode.execute();
        while (!this.rosMainNode.isStarted()) {
            ThreadTools.sleep((long)100L);
        }
        rosAPI_communicator.connect();
        System.out.println("IHMC ROS API node successfully started.");
    }

    private void setupOutputs(String namespace, String tfPrefix, String ... additionalPackages) {
        if (this.scsSensorCommunicationBridge != null) {
            // empty if block
        }
        Set outputTypes = GenericROSTranslationTools.getCoreOutputTopics();
        if (additionalPackages != null && additionalPackages.length > 0) {
            for (String additionalPackage : additionalPackages) {
                Set additionalOutputs = GenericROSTranslationTools.getOutputTopicsForPackage((String)additionalPackage);
                outputTypes.addAll(additionalOutputs);
            }
        }
        for (Class outputType : outputTypes) {
            RosMessagePacket rosAnnotation = outputType.getAnnotation(RosMessagePacket.class);
            String rosMessageTypeString = IHMCROSTranslationRuntimeTools.getROSMessageTypeStringFromIHMCMessageClass(outputType);
            Message message = (Message)this.messageFactory.newFromType(rosMessageTypeString);
            IHMCPacketToMsgPublisher publisher = IHMCPacketToMsgPublisher.createIHMCPacketToMsgPublisher(message, false, this.controllerCommunicationBridge, outputType);
            this.publishers.add(publisher);
            this.rosMainNode.attachPublisher(namespace + rosAnnotation.topic(), publisher);
        }
    }

    private void publishSimulatedCameraAndLidar(FullRobotModel fullRobotModel, HumanoidRobotSensorInformation sensorInformation, RosRobotConfigurationDataPublisher robotConfigurationPublisher) {
        AvatarRobotLidarParameters[] lidarParameters;
        if (sensorInformation.getCameraParameters().length > 0) {
            new RosSCSCameraPublisher(this.scsSensorCommunicationBridge, this.rosMainNode, this.rosClockCalculator, sensorInformation.getCameraParameters());
        }
        if ((lidarParameters = sensorInformation.getLidarParameters()).length > 0) {
            new RosSCSLidarPublisher(this.scsSensorCommunicationBridge, this.rosMainNode, this.rosClockCalculator, fullRobotModel, lidarParameters);
            AvatarRobotLidarParameters primaryLidar = lidarParameters[0];
            robotConfigurationPublisher.setAdditionalJointStatePublishing(primaryLidar.getLidarSpindleJointTopic(), primaryLidar.getLidarSpindleJointName());
        }
    }

    private void setupInputs(String namespace, HumanoidRobotDataReceiver robotDataReceiver, FullHumanoidRobotModel fullRobotModel, String ... additionalPackages) {
        Set inputTypes = GenericROSTranslationTools.getCoreInputTopics();
        if (additionalPackages != null && additionalPackages.length > 0) {
            for (String additionalPackage : additionalPackages) {
                Set additionalInputs = GenericROSTranslationTools.getInputTopicsForPackage((String)additionalPackage);
                inputTypes.addAll(additionalInputs);
            }
        }
        for (Class inputType : inputTypes) {
            RosMessagePacket rosAnnotation = inputType.getAnnotation(RosMessagePacket.class);
            String rosMessageTypeString = IHMCROSTranslationRuntimeTools.getROSMessageTypeStringFromIHMCMessageClass(inputType);
            Message message = (Message)this.messageFactory.newFromType(rosMessageTypeString);
            IHMCMsgToPacketSubscriber<Message> subscriber = IHMCMsgToPacketSubscriber.createIHMCMsgToPacketSubscriber(message, this.controllerCommunicationBridge, PacketDestination.CONTROLLER.ordinal());
            this.subscribers.add(subscriber);
            this.rosMainNode.attachSubscriber(namespace + rosAnnotation.topic(), subscriber);
        }
        RequestControllerStopSubscriber requestStopSubscriber = new RequestControllerStopSubscriber(this.controllerCommunicationBridge);
        this.rosMainNode.attachSubscriber(namespace + "/control/request_stop", (RosTopicSubscriberInterface)requestStopSubscriber);
    }

    private void setupRosLocalization() {
        new RosLocalizationPoseCorrectionSubscriber(this.rosMainNode, this.controllerCommunicationBridge, this.rosClockCalculator::computeRobotMonotonicTime);
        new IHMCProntoRosLocalizationUpdateSubscriber(this.rosMainNode, this.controllerCommunicationBridge, this.rosClockCalculator::computeRobotMonotonicTime);
    }

    private void setupErrorTopics() {
        this.controllerCommunicationBridge.attachListener(InvalidPacketNotificationPacket.class, (PacketConsumer)new PacketConsumer<InvalidPacketNotificationPacket>(){

            public void receivedPacket(InvalidPacketNotificationPacket packet) {
                System.err.println("Controller recieved invalid packet of type " + packet.getPacketClassSimpleNameAsString());
                System.err.println("Message: " + packet.getErrorMessageAsString());
            }
        });
        this.controllerCommunicationBridge.attachListener(ControllerCrashNotificationPacket.class, (PacketConsumer)new PacketConsumer<ControllerCrashNotificationPacket>(){

            public void receivedPacket(ControllerCrashNotificationPacket packet) {
                System.err.println("Controller crashed at " + packet.getControllerCrashLocation());
                System.err.println("Error message: " + packet.getErrorMessageAsString());
            }
        });
    }
}

