/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.microphone;

import us.ihmc.avatar.sensors.microphone.DrillDetectionAlgorithm;
import us.ihmc.avatar.sensors.microphone.DrillDetectionResult;
import us.ihmc.commons.Conversions;
import us.ihmc.simulationconstructionset.gui.BodePlotConstructor;

public class DrillDetectionAlgorithmSimple
extends DrillDetectionAlgorithm {
    private static final double decibelsOnThreshold = 80.0;
    private static final double frequencyBandLowerBound = 7000.0;
    private static final double frequencyBandUpperBound = 9000.0;

    @Override
    public DrillDetectionResult isDrillOn(byte[] audioBytes, int size) {
        int nlengthInSamples = size / 2;
        int[] audioData = new int[nlengthInSamples];
        for (int i = 0; i < nlengthInSamples; ++i) {
            byte LSB = audioBytes[2 * i];
            byte MSB = audioBytes[2 * i + 1];
            audioData[i] = MSB << 8 | LSB & 0xFF;
        }
        double[] input = new double[audioData.length];
        double[] time = new double[audioData.length];
        for (int i = 0; i < audioData.length; ++i) {
            input[i] = audioData[i];
            time[i] = (double)i / (double)this.getSampleRate();
        }
        double[][] fftData = BodePlotConstructor.computeFreqMagPhase((double[])time, (double[])input);
        double[] frequency = fftData[0];
        double[] magnitude = new double[fftData[1].length];
        for (int i = 0; i < fftData[1].length; ++i) {
            magnitude[i] = Conversions.amplitudeToDecibels((double)fftData[1][i]);
        }
        int frequencyBandLowerBoundIndex = 0;
        int frequencyBandUpperBoundIndex = 0;
        for (int index = 0; index < frequency.length; ++index) {
            if (frequency[index] <= 7000.0) {
                frequencyBandLowerBoundIndex = index;
            }
            if (!(frequency[index] <= 9000.0)) continue;
            frequencyBandUpperBoundIndex = index;
        }
        double bandAverageMag = 0.0;
        int rangeSize = frequencyBandUpperBoundIndex - frequencyBandLowerBoundIndex;
        for (int index = 0; index < rangeSize; ++index) {
            bandAverageMag += magnitude[frequencyBandLowerBoundIndex + index];
        }
        DrillDetectionResult result = new DrillDetectionResult();
        result.isOn = (bandAverageMag /= (double)rangeSize) >= 80.0;
        result.averageValues = new double[]{bandAverageMag};
        result.bodeData = this.getBodeData(time, input);
        return result;
    }

    @Override
    public int getNumReturnedBands() {
        return 1;
    }
}

