/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.microphone;

import java.util.ArrayList;
import us.ihmc.avatar.sensors.microphone.DrillDetectionAlgorithm;
import us.ihmc.avatar.sensors.microphone.DrillDetectionResult;
import us.ihmc.commons.Conversions;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.simulationconstructionset.gui.BodePlotConstructor;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DrillDetectionCalibrationHelper
extends DrillDetectionAlgorithm {
    private static final double decibelsDeltaToTripDetection = -5.8;
    private static final double lowerFrequencyBound = 1000.0;
    private static final double upperFrequencyBound = 8000.0;
    private static final double frequencyBandRange = 1000.0;
    private YoRegistry registry = new YoRegistry("DrillRegistry");
    private ArrayList<YoDouble> rawBandMagnitudes = new ArrayList();
    private ArrayList<AlphaFilteredYoVariable> filteredBandMagnitudes = new ArrayList();

    public DrillDetectionCalibrationHelper() {
        int numberOfBands = 7;
        for (int i = 0; i < numberOfBands; ++i) {
            double upperFrequency = 8000.0 - (double)i * 1000.0;
            double lowerFrequency = upperFrequency - 1000.0;
            this.rawBandMagnitudes.add(new YoDouble("raw" + (int)lowerFrequency + "" + (int)upperFrequency + "BandMagnitude", this.registry));
            this.filteredBandMagnitudes.add(new AlphaFilteredYoVariable("filtered" + (int)lowerFrequency + "" + (int)upperFrequency + "BandMagnitude", this.registry, 0.9));
        }
    }

    @Override
    public DrillDetectionResult isDrillOn(byte[] audioBytes, int size) {
        int nlengthInSamples = size / 2;
        int[] audioData = new int[nlengthInSamples];
        for (int i = 0; i < nlengthInSamples; ++i) {
            byte LSB = audioBytes[2 * i];
            byte MSB = audioBytes[2 * i + 1];
            audioData[i] = MSB << 8 | LSB & 0xFF;
        }
        double[] input = new double[audioData.length];
        double[] time = new double[audioData.length];
        for (int i = 0; i < audioData.length; ++i) {
            input[i] = audioData[i];
            time[i] = (double)i / (double)this.getSampleRate();
        }
        double[][] fftData = BodePlotConstructor.computeFreqMagPhase((double[])time, (double[])input);
        double[] frequency = fftData[0];
        double[] magnitude = new double[fftData[1].length];
        for (int i = 0; i < fftData[1].length; ++i) {
            magnitude[i] = Conversions.amplitudeToDecibels((double)fftData[1][i]);
        }
        int lowerIndex = 0;
        int upperIndex = 0;
        int numberOfBands = this.rawBandMagnitudes.size();
        for (int i = 0; i < numberOfBands; ++i) {
            double lowerFrequency = 8000.0 - (double)(numberOfBands - i) * 1000.0;
            double upperFrequency = lowerFrequency + 1000.0;
            for (int index = 0; index < frequency.length; ++index) {
                if (frequency[index] <= lowerFrequency) {
                    lowerIndex = index;
                }
                if (!(frequency[index] <= upperFrequency)) continue;
                upperIndex = index;
            }
            double bandMagnitude = 0.0;
            for (int index = lowerIndex; index < upperIndex; ++index) {
                bandMagnitude += magnitude[index];
            }
            if (upperIndex - lowerIndex > 0) {
                bandMagnitude /= (double)(upperIndex - lowerIndex);
            }
            this.rawBandMagnitudes.get(i).set(bandMagnitude);
            this.filteredBandMagnitudes.get(i).update(bandMagnitude);
        }
        DrillDetectionResult result = new DrillDetectionResult();
        result.isOn = false;
        result.averageValues = new double[numberOfBands];
        for (int i = 0; i < numberOfBands; ++i) {
            result.averageValues[i] = this.filteredBandMagnitudes.get(i).getDoubleValue();
        }
        result.bodeData = this.getBodeData(time, input);
        return result;
    }

    @Override
    public int getNumReturnedBands() {
        return this.rawBandMagnitudes.size();
    }
}

