/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.microphone;

import controller_msgs.msg.dds.DrillDetectionPacket;
import java.io.IOException;
import us.ihmc.avatar.sensors.microphone.DrillDetectionCalibrationHelper;
import us.ihmc.avatar.sensors.microphone.DrillDetectionResult;
import us.ihmc.avatar.sensors.microphone.DrillDetectionThread;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.net.ConnectionStateListener;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.Packet;
import us.ihmc.communication.packets.PacketDestination;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;

public class DrillDetectionProcess
extends DrillDetectionThread
implements ConnectionStateListener {
    public static final long SEND_PERIOD_MS = 1000L;
    private long lastSentPacketTimestamp = 0L;
    private PacketCommunicator packetCommunicator = null;

    public DrillDetectionProcess() {
        super(new DrillDetectionCalibrationHelper());
    }

    public void connected() {
        System.out.println("Connected to the network manager");
    }

    public void disconnected() {
        System.out.println("Disconnected from the network manager");
    }

    @Override
    public void onDrillDetectionResult(DrillDetectionResult result) {
        if (!this.packetCommunicator.isConnected()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastSentPacketTimestamp < 1000L) {
            return;
        }
        DrillDetectionPacket packet = new DrillDetectionPacket();
        packet.setDestination(PacketDestination.UI.ordinal());
        packet.setIsDrillOn(result.isOn);
        this.packetCommunicator.send((Packet)packet);
        this.lastSentPacketTimestamp = now;
    }

    public void execute() throws IOException {
        System.out.println("Connection to the network manager on the CPU0...");
        this.packetCommunicator = PacketCommunicator.createTCPPacketCommunicatorClient((String)"10.7.3.100", (NetworkPorts)NetworkPorts.DRILL_DETECTOR, (NetClassList)new IHMCCommunicationKryoNetClassList());
        this.packetCommunicator.attachStateListener((ConnectionStateListener)this);
        this.packetCommunicator.connect();
        System.out.println("Starting the webcam lifecycle management...");
        this.start();
    }

    public void terminate() throws InterruptedException {
        System.out.println("Disconnection from the network manager...");
        this.packetCommunicator.disconnect();
        System.out.println("Shutting down the webcam thread...");
        this.shutdown();
        this.join();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        DrillDetectionProcess process = new DrillDetectionProcess();
        process.execute();
        while (process.isRunning()) {
            ThreadTools.sleep((long)500L);
        }
        process.terminate();
    }
}

