/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.microphone;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import us.ihmc.avatar.sensors.microphone.DrillDetectionAlgorithm;
import us.ihmc.avatar.sensors.microphone.DrillDetectionCalibrationHelper;
import us.ihmc.avatar.sensors.microphone.DrillDetectionResult;
import us.ihmc.avatar.sensors.microphone.DrillDetectionThread;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.plotting.artifact.PointListArtifact;
import us.ihmc.plotting.Plotter;
import us.ihmc.plotting.PlotterPanel;
import us.ihmc.simulationconstructionset.gui.FFTPlotter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DrillDetectionUI {
    DrillDetectionAlgorithm detectionAlgorithm = new DrillDetectionCalibrationHelper();
    private final DrillDetectionThread detectorThread = new DrillDetectionThread(this.detectionAlgorithm){

        @Override
        public void onDrillDetectionResult(final DrillDetectionResult result) {
            Runnable processResult = new Runnable(){

                @Override
                public void run() {
                    DrillDetectionUI.this.processDrillDetectionResult(result);
                }
            };
            SwingUtilities.invokeLater(processResult);
        }
    };
    private JPanel soundDetectorGUI = null;
    private Container fftPlotContainer = null;
    private Plotter boolPlotter = null;
    private int dataSize = 0;
    private int numBands;
    YoRegistry registry = new YoRegistry("registry");
    ArrayList<YoDouble> bandValues = new ArrayList();
    boolean shouldZero = true;
    double[] zeroValues;
    private final TimeSeriesCollection dataset;
    private int time = 0;

    public DrillDetectionUI() {
        System.out.println("Creating the UI");
        JFrame frame = new JFrame("Drill Detection UI");
        this.numBands = this.detectionAlgorithm.getNumReturnedBands();
        this.dataset = new TimeSeriesCollection();
        for (int i = 0; i < this.numBands; ++i) {
            YoDouble iVariable = new YoDouble(i + "AverageBandMagnitude", this.registry);
            this.bandValues.add(iVariable);
            this.dataset.addSeries(new TimeSeries((Comparable)((Object)(i + "th Band"))));
        }
        this.zeroValues = new double[this.numBands];
        frame.setContentPane(this.createContentPane());
        frame.setDefaultCloseOperation(3);
        frame.setSize(1000, 900);
        frame.setVisible(true);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DrillDetectionUI.this.onShutdown();
            }
        });
        this.detectorThread.start();
    }

    private JPanel createContentPane() {
        this.soundDetectorGUI = new JPanel(new GridBagLayout());
        this.soundDetectorGUI.setOpaque(true);
        this.fftPlotContainer = new Container();
        this.fftPlotContainer.setBackground(Color.blue);
        GridBagConstraints fftLayout = new GridBagConstraints();
        fftLayout.gridx = 0;
        fftLayout.gridy = 0;
        fftLayout.weightx = 1.0;
        fftLayout.fill = 2;
        this.soundDetectorGUI.add((Component)this.fftPlotContainer, fftLayout);
        PlotterPanel boolPlotterPanel = new PlotterPanel();
        GridBagConstraints boolPlotterLayout = new GridBagConstraints();
        boolPlotterLayout.gridx = 0;
        boolPlotterLayout.gridy = 1;
        boolPlotterLayout.weightx = 1.0;
        boolPlotterLayout.fill = 2;
        this.soundDetectorGUI.add((Component)boolPlotterPanel, boolPlotterLayout);
        this.boolPlotter = boolPlotterPanel.getPlotter();
        this.boolPlotter.setFocusPointX(320.0);
        this.boolPlotter.setFocusPointY(80.0);
        this.boolPlotter.setViewRange(200.0);
        JFreeChart bandGraph = ChartFactory.createTimeSeriesChart((String)"Band Magnitudes", (String)"Time", (String)"Magnitude(dB)", (XYDataset)this.dataset, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = bandGraph.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setAutoRange(true);
        axis.setFixedAutoRange(60000.0);
        axis = plot.getRangeAxis();
        axis.setRange(-25.0, 25.0);
        ChartPanel chartPanel = new ChartPanel(bandGraph);
        ++boolPlotterLayout.gridy;
        this.soundDetectorGUI.add((Component)chartPanel, boolPlotterLayout);
        JButton zero = new JButton("Zero Sound Differences");
        zero.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrillDetectionUI.this.shouldZero = true;
            }
        });
        ++boolPlotterLayout.gridy;
        this.soundDetectorGUI.add((Component)zero, boolPlotterLayout);
        return this.soundDetectorGUI;
    }

    private void processDrillDetectionResult(DrillDetectionResult result) {
        int i;
        this.soundDetectorGUI.remove(this.fftPlotContainer);
        FFTPlotter plot = new FFTPlotter(result.bodeData, "", "(Hz)", "(dB)", "(deg)");
        this.fftPlotContainer = plot.getContentPane();
        GridBagConstraints fftLayout = new GridBagConstraints();
        fftLayout.gridx = 0;
        fftLayout.gridy = 0;
        fftLayout.weightx = 1.0;
        fftLayout.fill = 2;
        this.soundDetectorGUI.add((Component)this.fftPlotContainer, fftLayout);
        int x = this.dataSize++;
        double rawValue = result.isOn ? 150.0 : 0.0;
        Point2D pRaw = new Point2D((double)x, rawValue);
        PointListArtifact paRaw = new PointListArtifact("drillOn_" + x, pRaw);
        this.boolPlotter.addArtifact((Artifact)paRaw);
        if (this.numBands != result.averageValues.length) {
            System.err.println("Number of plotters != array size");
            return;
        }
        Millisecond now = new Millisecond();
        double average = 0.0;
        for (i = 0; i < this.numBands; ++i) {
            this.bandValues.get(i).set(result.averageValues[i]);
            average += result.averageValues[i];
        }
        if (this.numBands != 0) {
            average /= (double)this.numBands;
        }
        for (i = 0; i < this.numBands; ++i) {
            if (this.shouldZero) {
                this.zeroValues[i] = this.bandValues.get(i).getDoubleValue() - average;
            }
            this.dataset.getSeries(i).add((RegularTimePeriod)now, this.bandValues.get(i).getDoubleValue() - average - this.zeroValues[i]);
        }
        this.shouldZero = false;
        this.soundDetectorGUI.revalidate();
    }

    private void onShutdown() {
        System.out.println("Killing drill detection thread...");
        this.detectorThread.shutdown();
        try {
            this.detectorThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Terminating the UI");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DrillDetectionUI();
            }
        });
    }
}

