/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.multisense;

import controller_msgs.msg.dds.MultisenseParameterPacket;
import dynamic_reconfigure.BoolParameter;
import dynamic_reconfigure.DoubleParameter;
import dynamic_reconfigure.ReconfigureRequest;
import dynamic_reconfigure.ReconfigureResponse;
import dynamic_reconfigure.StrParameter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.ros.exception.RemoteException;
import org.ros.internal.message.Message;
import org.ros.node.NodeConfiguration;
import org.ros.node.parameter.ParameterListener;
import org.ros.node.parameter.ParameterTree;
import org.ros.node.service.ServiceResponseListener;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.log.LogTools;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.tools.processManagement.ProcessStreamGobbler;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosServiceClient;
import us.ihmc.utilities.ros.publisher.RosDoublePublisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;

public class MultiSenseParamaterSetter
implements PacketConsumer<MultisenseParameterPacket> {
    private double gain;
    private double motorSpeed;
    private boolean ledEnable;
    private boolean flashEnable;
    private double dutyCycle;
    private boolean autoExposure;
    private boolean autoWhitebalance;
    private final RosServiceClient<ReconfigureRequest, ReconfigureResponse> multiSenseClient;
    private final RosMainNode rosMainNode;
    private ParameterTree params;
    private IHMCROS2Publisher<MultisenseParameterPacket> publisher;

    public MultiSenseParamaterSetter(RosMainNode rosMainNode, ROS2NodeInterface ros2Node) {
        this.rosMainNode = rosMainNode;
        this.multiSenseClient = new RosServiceClient("dynamic_reconfigure/Reconfigure");
        rosMainNode.attachServiceClient("multisense/set_parameters", this.multiSenseClient);
        ROS2Tools.createCallbackSubscription((ROS2NodeInterface)ros2Node, MultisenseParameterPacket.class, (String)"ihmc/multisense_parameter", s -> this.receivedPacket((MultisenseParameterPacket)s.takeNextData()));
        this.publisher = ROS2Tools.createPublisher((ROS2NodeInterface)ros2Node, MultisenseParameterPacket.class, (String)"ihmc/initial_multisense_parameter");
    }

    public MultiSenseParamaterSetter(RosMainNode rosMainNode2) {
        this.rosMainNode = rosMainNode2;
        this.multiSenseClient = new RosServiceClient("dynamic_reconfigure/Reconfigure");
    }

    public boolean setupNativeROSCommunicator(double lidarSpindleVelocity) {
        if (this.isRosVersion("hydro")) {
            LogTools.info((String)"Using ROS Hydro");
            return this.shellOutSpindleSpeedCommand(this.spindleSpeedShellString("hydro", lidarSpindleVelocity));
        }
        if (this.isRosVersion("groovy")) {
            LogTools.info((String)"Using ROS Groovy");
            return this.shellOutSpindleSpeedCommand(this.spindleSpeedShellString("groovy", lidarSpindleVelocity));
        }
        if (this.isRosVersion("fuerte")) {
            LogTools.info((String)"Using ROS Fuerte");
            return this.shellOutSpindleSpeedCommand(this.spindleSpeedShellString("fuerte", lidarSpindleVelocity));
        }
        if (this.isRosVersion("indigo")) {
            LogTools.info((String)"Using ROS Indigo");
            return this.shellOutSpindleSpeedCommand(this.spindleSpeedShellString("indigo", lidarSpindleVelocity));
        }
        if (this.isRosVersion("kinetic")) {
            LogTools.info((String)"Using ROS Kinetic");
            return this.shellOutSpindleSpeedCommand(this.spindleSpeedShellString("kinetic", lidarSpindleVelocity));
        }
        if (this.isRosVersion("melodic")) {
            LogTools.info((String)"Using ROS Melodic");
            return this.shellOutSpindleSpeedCommand(this.spindleSpeedShellString("melodic", lidarSpindleVelocity));
        }
        throw new RuntimeException();
    }

    private String[] spindleSpeedShellString(String distroName, double lidarSpindleVelocity) {
        return new String[]{"env", "ROS_MASTER_URI=", NetworkParameters.getROSURI().toString(), "sh", "-c", "/opt/ros/" + distroName + "/setup.sh; rosrun dynamic_reconfigure dynparam set /multisense motor_speed " + lidarSpindleVelocity + "; rosrun dynamic_reconfigure dynparam set /multisense network_time_sync true"};
    }

    private boolean shellOutSpindleSpeedCommand(String[] shellCommandString) {
        ProcessBuilder builder = new ProcessBuilder(shellCommandString);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            Process process = builder.start();
            LogTools.info((String)"Spindle speed shellout process started");
            new ProcessStreamGobbler("ROS spindle speed shellout err", process, process.getErrorStream(), System.err).start();
            new ProcessStreamGobbler("ROS spindle speed shellout out", process, process.getInputStream(), printStream).start();
            process.waitFor();
            LogTools.info((String)"Spindle speed shellout process finished");
            String errorString = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
            System.out.println(errorString);
            if (!errorString.contains("Unable to register")) {
                LogTools.info((String)"ROS appears to be running and spindle is started");
                return true;
            }
            LogTools.info((String)"Unable to register to ROS master. Trying again...");
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isRosVersion(String distroName) {
        return new File("/opt/ros/" + distroName).exists();
    }

    public void setupMultisenseSpindleSpeedPublisher(RosMainNode rosMainNode, final double lidarSpindleVelocity) {
        RosDoublePublisher rosDoublePublisher = new RosDoublePublisher(true){

            public void connected() {
                this.publish(lidarSpindleVelocity);
            }
        };
        rosMainNode.attachPublisher("/multisense/set_spindle_speed", (RosTopicPublisher)rosDoublePublisher);
    }

    public void handleMultisenseParameters(MultisenseParameterPacket object) {
        if (object.getInitialize()) {
            if (this.rosMainNode.isStarted()) {
                this.params = this.rosMainNode.getParameters();
                this.send();
            }
        } else {
            this.setMultisenseParameters(object);
        }
    }

    private void send() {
        if (this.params == null) {
            return;
        }
        this.publisher.publish((Object)HumanoidMessageTools.createMultisenseParameterPacket((boolean)false, (double)this.params.getDouble("/multisense/gain"), (double)this.params.getDouble("/multisense/motor_speed"), (double)this.params.getDouble("/multisense/led_duty_cycle"), (boolean)this.params.getBoolean("/multisense/lighting"), (boolean)this.params.getBoolean("/multisense/flash"), (boolean)this.params.getBoolean("multisense/auto_exposure"), (boolean)this.params.getBoolean("multisense/auto_white_balance")));
    }

    public void initializeParameterListeners() {
        this.rosMainNode.attachParameterListener("/multisense/motor_speed", new ParameterListener(){

            public void onNewValue(Object value) {
                MultiSenseParamaterSetter.this.send();
            }
        });
        this.rosMainNode.attachParameterListener("/multisense/gain", new ParameterListener(){

            public void onNewValue(Object value) {
                MultiSenseParamaterSetter.this.send();
            }
        });
        this.rosMainNode.attachParameterListener("/multisense/led_duty_cycle", new ParameterListener(){

            public void onNewValue(Object value) {
                MultiSenseParamaterSetter.this.send();
            }
        });
        this.rosMainNode.attachParameterListener("/multisense/lighting", new ParameterListener(){

            public void onNewValue(Object value) {
                MultiSenseParamaterSetter.this.send();
            }
        });
        this.rosMainNode.attachParameterListener("/multisense/flash", new ParameterListener(){

            public void onNewValue(Object value) {
                MultiSenseParamaterSetter.this.send();
            }
        });
        this.rosMainNode.attachParameterListener("/multisense/auto_exposure", new ParameterListener(){

            public void onNewValue(Object value) {
                MultiSenseParamaterSetter.this.send();
            }
        });
        this.rosMainNode.attachParameterListener("/multisense/motor_speed", new ParameterListener(){

            public void onNewValue(Object value) {
                MultiSenseParamaterSetter.this.send();
            }
        });
        this.rosMainNode.attachParameterListener("/multisense/auto_white_balance", new ParameterListener(){

            public void onNewValue(Object value) {
                MultiSenseParamaterSetter.this.send();
            }
        });
    }

    public void setMultisenseResolution(RosMainNode rosMainNode) {
        try {
            Thread setupThread = new Thread(){

                @Override
                public void run() {
                    MultiSenseParamaterSetter.this.multiSenseClient.waitTillConnected();
                    ReconfigureRequest request = (ReconfigureRequest)MultiSenseParamaterSetter.this.multiSenseClient.getMessage();
                    StrParameter resolutionParam = (StrParameter)NodeConfiguration.newPrivate().getTopicMessageFactory().newFromType("dynamic_reconfigure/StrParameter");
                    resolutionParam.setName("resolution");
                    System.out.println("Setting multisense resolution to 1024x544x128");
                    resolutionParam.setValue("1024x544x256");
                    request.getConfig().getStrs().add(resolutionParam);
                    DoubleParameter fpsParam = (DoubleParameter)NodeConfiguration.newPrivate().getTopicMessageFactory().newFromType("dynamic_reconfigure/DoubleParameter");
                    fpsParam.setName("fps");
                    fpsParam.setValue(30.0);
                    request.getConfig().getDoubles().add(fpsParam);
                    DoubleParameter gainParam = (DoubleParameter)NodeConfiguration.newPrivate().getTopicMessageFactory().newFromType("dynamic_reconfigure/DoubleParameter");
                    gainParam.setName("gain");
                    gainParam.setValue(3.2);
                    request.getConfig().getDoubles().add(gainParam);
                    MultiSenseParamaterSetter.this.multiSenseClient.call((Message)request, (ServiceResponseListener)new ServiceResponseListener<ReconfigureResponse>(){

                        public void onSuccess(ReconfigureResponse response) {
                            System.out.println("Set resolution to " + ((StrParameter)response.getConfig().getStrs().get(0)).getValue());
                        }

                        public void onFailure(RemoteException e) {
                            e.printStackTrace();
                        }
                    });
                }
            };
            setupThread.start();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public void setMultisenseParameters(MultisenseParameterPacket object) {
        this.multiSenseClient.waitTillConnected();
        final ReconfigureRequest request = (ReconfigureRequest)this.multiSenseClient.getMessage();
        if (object.getGain() != this.gain) {
            this.gain = object.getGain();
            DoubleParameter gainParam = (DoubleParameter)NodeConfiguration.newPrivate().getTopicMessageFactory().newFromType("dynamic_reconfigure/DoubleParameter");
            gainParam.setName("gain");
            gainParam.setValue(this.gain);
            request.getConfig().getDoubles().add(gainParam);
        }
        if (object.getMotorSpeed() != this.motorSpeed) {
            this.motorSpeed = object.getMotorSpeed();
            DoubleParameter motorSpeedParam = (DoubleParameter)NodeConfiguration.newPrivate().getTopicMessageFactory().newFromType("dynamic_reconfigure/DoubleParameter");
            motorSpeedParam.setName("motor_speed");
            motorSpeedParam.setValue(this.motorSpeed);
            request.getConfig().getDoubles().add(motorSpeedParam);
        }
        if (object.getDutyCycle() != this.dutyCycle) {
            this.dutyCycle = object.getDutyCycle();
            DoubleParameter dutyCycleParam = (DoubleParameter)NodeConfiguration.newPrivate().getTopicMessageFactory().newFromType("dynamic_reconfigure/DoubleParameter");
            dutyCycleParam.setName("led_duty_cycle");
            dutyCycleParam.setValue(this.dutyCycle);
            request.getConfig().getDoubles().add(dutyCycleParam);
        }
        if (object.getLedEnable() != this.ledEnable) {
            this.ledEnable = object.getLedEnable();
            BoolParameter ledEnableParam = (BoolParameter)NodeConfiguration.newPrivate().getTopicMessageFactory().newFromType("dynamic_reconfigure/BoolParameter");
            ledEnableParam.setName("lighting");
            ledEnableParam.setValue(this.ledEnable);
            request.getConfig().getBools().add(ledEnableParam);
        }
        if (object.getFlashEnable() != this.flashEnable) {
            this.flashEnable = object.getFlashEnable();
            BoolParameter flashEnableParam = (BoolParameter)NodeConfiguration.newPrivate().getTopicMessageFactory().newFromType("dynamic_reconfigure/BoolParameter");
            flashEnableParam.setName("flash");
            flashEnableParam.setValue(this.flashEnable);
            request.getConfig().getBools().add(flashEnableParam);
        }
        if (object.getAutoExposure() != this.autoExposure) {
            this.autoExposure = object.getAutoExposure();
            BoolParameter autoExposureParam = (BoolParameter)NodeConfiguration.newPrivate().getTopicMessageFactory().newFromType("dynamic_reconfigure/BoolParameter");
            autoExposureParam.setName("auto_exposure");
            autoExposureParam.setValue(this.autoExposure);
            request.getConfig().getBools().add(autoExposureParam);
        }
        if (object.getAutoWhiteBalance() != this.autoWhitebalance) {
            this.autoWhitebalance = object.getAutoWhiteBalance();
            BoolParameter autoWhiteBalanceParam = (BoolParameter)NodeConfiguration.newPrivate().getTopicMessageFactory().newFromType("dynamic_reconfigure/BoolParameter");
            autoWhiteBalanceParam.setName("auto_white_balance");
            autoWhiteBalanceParam.setValue(this.autoWhitebalance);
            request.getConfig().getBools().add(autoWhiteBalanceParam);
        }
        new Thread(){

            @Override
            public void run() {
                MultiSenseParamaterSetter.this.multiSenseClient.call((Message)request, (ServiceResponseListener)new ServiceResponseListener<ReconfigureResponse>(){

                    public void onSuccess(ReconfigureResponse response) {
                        System.out.println("successful" + ((DoubleParameter)response.getConfig().getDoubles().get(0)).getValue());
                    }

                    public void onFailure(RemoteException e) {
                        e.printStackTrace();
                    }
                });
            }
        }.start();
    }

    public void receivedPacket(MultisenseParameterPacket object) {
        this.handleMultisenseParameters(object);
    }
}

