/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.realsense;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.ArrayList;
import java.util.function.Consumer;
import map_sense.RawGPUPlanarRegionList;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.tuple.Pair;
import org.ros.message.Time;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.stereoPointCloudPublisher.CollidingScanRegionFilter;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.avatar.sensors.realsense.MapsenseTools;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.IHMCROS2Callback;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.ihmcPerception.depthData.CollisionBoxProvider;
import us.ihmc.ihmcPerception.depthData.CollisionShapeTester;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotEnvironmentAwareness.communication.converters.ScanRegionFilter;
import us.ihmc.robotEnvironmentAwareness.updaters.GPUPlanarRegionUpdater;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataBuffer;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;
import us.ihmc.utilities.ros.RosNodeInterface;
import us.ihmc.utilities.ros.publisher.RosPoseStampedPublisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;

public class DelayFixedPlanarRegionsSubscription {
    public static final double INITIAL_DELAY_OFFSET = 0.07;
    private final ResettableExceptionHandlingExecutorService executorService;
    private final GPUPlanarRegionUpdater gpuPlanarRegionUpdater = new GPUPlanarRegionUpdater();
    private final RobotConfigurationDataBuffer robotConfigurationDataBuffer;
    private final HumanoidReferenceFrames referenceFrames;
    private final ROS2NodeInterface ros2Node;
    private final DRCRobotModel robotModel;
    private final String topic;
    private final Consumer<Pair<Long, PlanarRegionsList>> callback;
    private final MutableDouble delayOffset = new MutableDouble(0.07);
    private final FullHumanoidRobotModel fullRobotModel;
    private final RobotROSClockCalculator rosClockCalculator;
    private IHMCROS2Callback<?> robotConfigurationDataSubscriber;
    private RosPoseStampedPublisher sensorPosePublisher;
    private boolean posePublisherEnabled = false;
    private CollisionBoxProvider collisionBoxProvider;
    private CollidingScanRegionFilter collisionFilter;
    private boolean enabled = false;
    private AbstractRosTopicSubscriber<RawGPUPlanarRegionList> subscriber;
    private double delay = 0.0;
    private RosNodeInterface ros1Node;

    public DelayFixedPlanarRegionsSubscription(ROS2NodeInterface ros2Node, DRCRobotModel robotModel, String topic, Consumer<Pair<Long, PlanarRegionsList>> callback) {
        this.ros2Node = ros2Node;
        this.robotModel = robotModel;
        this.topic = topic;
        this.callback = callback;
        this.rosClockCalculator = robotModel.getROSClockCalculator();
        ROS2Tools.createCallbackSubscription2((ROS2NodeInterface)ros2Node, (ROS2Topic)ROS2Tools.getRobotConfigurationDataTopic((String)robotModel.getSimpleRobotName()), this.rosClockCalculator::receivedRobotConfigurationData);
        ROS2Tools.createCallbackSubscription2((ROS2NodeInterface)ros2Node, (ROS2Topic)ROS2Tools.MAPSENSE_REGIONS_DELAY_OFFSET, message -> this.delayOffset.setValue(message.getData()));
        boolean daemon = true;
        int queueSize = 1;
        this.executorService = MissingThreadTools.newSingleThreadExecutor((String)"ROS1PlanarRegionsSubscriber", (boolean)daemon, (int)queueSize);
        this.gpuPlanarRegionUpdater.attachROS2Tuner(ros2Node);
        this.fullRobotModel = robotModel.createFullRobotModel();
        this.robotConfigurationDataBuffer = new RobotConfigurationDataBuffer();
        this.sensorPosePublisher = new RosPoseStampedPublisher(false);
        this.referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel, robotModel.getSensorInformation());
        this.collisionBoxProvider = robotModel.getCollisionBoxProvider();
        CollisionShapeTester shapeTester = new CollisionShapeTester();
        for (RobotSide robotSide : RobotSide.values) {
            ArrayList joints = new ArrayList();
            RigidBodyBasics shin = this.fullRobotModel.getFoot((Enum)robotSide).getParentJoint().getPredecessor().getParentJoint().getPredecessor();
            MultiBodySystemTools.collectJointPath((RigidBodyBasics)this.fullRobotModel.getPelvis(), (RigidBodyBasics)shin, joints);
            joints.forEach(joint -> shapeTester.addJoint(this.collisionBoxProvider, joint));
        }
        this.collisionFilter = new CollidingScanRegionFilter(shapeTester);
    }

    public void subscribe(RosNodeInterface ros1Node) {
        this.ros1Node = ros1Node;
        this.ros1Node.attachPublisher("/atlas/sensors/chest_l515/pose", (RosTopicPublisher)this.sensorPosePublisher);
        this.rosClockCalculator.subscribeToROS1Topics(ros1Node);
        this.subscriber = MapsenseTools.createROS1Callback(this.topic, ros1Node, this::acceptRawGPUPlanarRegionsList);
    }

    public void unsubscribe(RosNodeInterface ros1Node) {
        ros1Node.removeSubscriber(this.subscriber);
        this.rosClockCalculator.unsubscribeFromROS1Topics(ros1Node);
    }

    private void acceptRobotConfigurationData(RobotConfigurationData robotConfigurationData) {
        this.robotConfigurationDataBuffer.update(robotConfigurationData);
    }

    private void acceptRawGPUPlanarRegionsList(RawGPUPlanarRegionList rawGPUPlanarRegionList) {
        if (this.enabled) {
            this.executorService.clearQueueAndExecute(() -> {
                long timestamp = rawGPUPlanarRegionList.getHeader().getStamp().totalNsecs();
                double seconds = this.delayOffset.getValue();
                timestamp -= Conversions.secondsToNanoseconds((double)seconds);
                if (!this.rosClockCalculator.offsetIsDetermined()) {
                    this.delay = Double.NaN;
                    return;
                }
                long controllerTime = this.rosClockCalculator.computeRobotMonotonicTime(timestamp);
                if (controllerTime == -1L) {
                    this.delay = Double.NaN;
                    return;
                }
                long newestTimestamp = this.robotConfigurationDataBuffer.getNewestTimestamp();
                if (newestTimestamp == -1L) {
                    this.delay = Double.NaN;
                    return;
                }
                boolean waitIfNecessary = false;
                long selectedTimestamp = this.robotConfigurationDataBuffer.updateFullRobotModel(waitIfNecessary, controllerTime, (FullRobotModel)this.fullRobotModel, null);
                if (selectedTimestamp != -1L) {
                    long currentTimeInWall = this.ros1Node.getCurrentTime().totalNsecs();
                    long selectedTimeInWall = selectedTimestamp - this.rosClockCalculator.getCurrentTimestampOffset();
                    this.delay = Conversions.nanosecondsToSeconds((long)(currentTimeInWall - selectedTimeInWall));
                    try {
                        this.referenceFrames.updateFrames();
                    }
                    catch (NotARotationMatrixException e) {
                        LogTools.error((String)e.getMessage());
                    }
                    PlanarRegionsList planarRegionsList = this.gpuPlanarRegionUpdater.generatePlanarRegions(rawGPUPlanarRegionList);
                    try {
                        planarRegionsList.applyTransform(MapsenseTools.getTransformFromCameraToWorld());
                        planarRegionsList.applyTransform((RigidBodyTransformReadOnly)this.referenceFrames.getSteppingCameraFrame().getTransformToWorldFrame());
                        this.collisionFilter.update();
                        this.gpuPlanarRegionUpdater.filterCollidingPlanarRegions(planarRegionsList, (ScanRegionFilter)this.collisionFilter);
                        if (this.posePublisherEnabled) {
                            RigidBodyTransform transform = this.referenceFrames.getSteppingCameraFrame().getTransformToWorldFrame();
                            this.sensorPosePublisher.publish("chest_l515", (Vector3D)transform.getTranslation(), new Quaternion((Orientation3DReadOnly)transform.getRotation()), new Time((double)currentTimeInWall));
                        }
                    }
                    catch (NotARotationMatrixException e) {
                        LogTools.error((String)e.getMessage());
                    }
                    this.callback.accept((Pair<Long, PlanarRegionsList>)Pair.of((Object)currentTimeInWall, (Object)planarRegionsList));
                }
            });
        }
    }

    public void destroy() {
        this.executorService.destroy();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            if (enabled) {
                this.robotConfigurationDataSubscriber = ROS2Tools.createCallbackSubscription2((ROS2NodeInterface)this.ros2Node, (ROS2Topic)ROS2Tools.getRobotConfigurationDataTopic((String)this.robotModel.getSimpleRobotName()), this::acceptRobotConfigurationData);
            } else {
                this.executorService.interruptAndReset();
                this.robotConfigurationDataSubscriber.destroy();
                this.robotConfigurationDataSubscriber = null;
            }
        }
        this.enabled = enabled;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setPosePublisherEnabled(boolean posePublisherEnabled) {
        this.posePublisherEnabled = posePublisherEnabled;
    }
}

