/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.realsense;

import controller_msgs.msg.dds.PlanarRegionsListMessage;
import map_sense.RawGPUPlanarRegionList;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.ROS2SyncedBufferedRobotModel;
import us.ihmc.avatar.sensors.realsense.MapsenseTools;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.updaters.GPUPlanarRegionUpdater;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.Timer;
import us.ihmc.tools.TimerSnapshot;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosNodeInterface;

public class MapSensePlanarRegionROS1Bridge {
    private final GPUPlanarRegionUpdater gpuPlanarRegionUpdater = new GPUPlanarRegionUpdater();
    private final ResettableExceptionHandlingExecutorService executorService;
    private final IHMCROS2Publisher<PlanarRegionsListMessage> publisher;
    private final ROS2SyncedBufferedRobotModel syncedRobot;
    private final Timer throttleTimer = new Timer();

    public MapSensePlanarRegionROS1Bridge(DRCRobotModel robotModel, RosMainNode ros1Node, ROS2NodeInterface ros2Node) {
        this.syncedRobot = new ROS2SyncedBufferedRobotModel(robotModel, ros2Node);
        MapsenseTools.createROS1Callback((RosNodeInterface)ros1Node, this::acceptMessage);
        this.publisher = ROS2Tools.createPublisher((ROS2NodeInterface)ros2Node, (ROS2Topic)ROS2Tools.MAPSENSE_REGIONS);
        boolean daemon = true;
        int queueSize = 1;
        this.executorService = MissingThreadTools.newSingleThreadExecutor((String)this.getClass().getSimpleName(), (boolean)daemon, (int)queueSize);
        this.throttleTimer.reset();
    }

    private void acceptMessage(RawGPUPlanarRegionList rawGPUPlanarRegionList) {
        this.executorService.clearQueueAndExecute(() -> {
            TimerSnapshot dataReceptionTimerSnapshot = this.syncedRobot.getDataReceptionTimerSnapshot();
            if (!dataReceptionTimerSnapshot.isRunning(2.0)) {
                LogTools.info((String)"No robot data in {} s", (Object)dataReceptionTimerSnapshot.getTimePassedSinceReset());
            } else {
                this.syncedRobot.updateToBuffered(rawGPUPlanarRegionList.getHeader().getStamp().totalNsecs());
                PlanarRegionsList planarRegionsList = this.gpuPlanarRegionUpdater.generatePlanarRegions(rawGPUPlanarRegionList);
                planarRegionsList.applyTransform(MapsenseTools.getTransformFromCameraToWorld());
                planarRegionsList.applyTransform((RigidBodyTransformReadOnly)this.syncedRobot.getReferenceFrames().getSteppingCameraFrame().getTransformToWorldFrame());
                this.publisher.publish((Object)PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)planarRegionsList));
            }
        });
    }

    public void destroy() {
        this.executorService.destroy();
    }
}

