/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.realsense;

import controller_msgs.msg.dds.VideoPacket;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import sensor_msgs.msg.dds.CompressedImage;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.codecs.yuv.JPEGEncoder;
import us.ihmc.codecs.yuv.YUVPictureConverter;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.log.LogTools;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.Timer;
import us.ihmc.tools.UnitConversions;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class RealsenseVideoROS1Bridge
extends AbstractRosTopicSubscriber<sensor_msgs.CompressedImage> {
    private static final boolean THROTTLE = false;
    private static final double MIN_PUBLISH_PERIOD = UnitConversions.hertzToSeconds((double)24.0);
    private final IHMCROS2Publisher<VideoPacket> publisher;
    private final Timer throttleTimer = new Timer();
    private final ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)((Object)((Object)this)).getClass().getSimpleName(), (boolean)true, (int)1);
    private final YUVPictureConverter converter = new YUVPictureConverter();
    private final JPEGEncoder encoder = new JPEGEncoder();

    public RealsenseVideoROS1Bridge(RosMainNode ros1Node, ROS2Node ros2Node, String ros1InputTopic, ROS2Topic<VideoPacket> ros2OutputTopic) {
        super("sensor_msgs/CompressedImage");
        String ros1Topic = ros1InputTopic;
        LogTools.info((String)"Subscribing ROS 1: {}", (Object)ros1Topic);
        ros1Node.attachSubscriber(ros1Topic, (RosTopicSubscriberInterface)this);
        ROS2Topic<VideoPacket> ros2Topic = ros2OutputTopic;
        LogTools.info((String)"Publishing ROS 2: {}", (Object)ros2Topic.getName());
        this.publisher = ROS2Tools.createPublisher((ROS2NodeInterface)ros2Node, ros2Topic, (ROS2QosProfile)ROS2QosProfile.DEFAULT());
    }

    public void onNewMessage(sensor_msgs.CompressedImage ros1Image) {
        this.compute(ros1Image);
    }

    private void waitThenAct(sensor_msgs.CompressedImage ros1Image) {
        this.throttleTimer.sleepUntilExpiration(MIN_PUBLISH_PERIOD);
        this.throttleTimer.reset();
        this.compute(ros1Image);
    }

    private void compute(sensor_msgs.CompressedImage ros1Image) {
        try {
            byte[] payload = ros1Image.getData().array();
            int offset = ros1Image.getData().arrayOffset();
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(payload, offset, payload.length - offset));
            YUVPicture picture = this.converter.fromBufferedImage(bufferedImage, YUVPicture.YUVSubsamplingType.YUV420);
            ByteBuffer buffer = this.encoder.encode(picture, 75);
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data);
            VideoPacket message = new VideoPacket();
            message.setTimestamp(System.nanoTime());
            message.getData().add(data);
            this.publisher.publish((Object)message);
        }
        catch (Exception e) {
            LogTools.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    private void createROS2CompressedImage(sensor_msgs.CompressedImage ros1Image) {
        CompressedImage ros2Image = new CompressedImage();
        byte[] data = ros1Image.getData().array();
        int dataOffset = ros1Image.getData().arrayOffset();
        int length = data.length;
        ros2Image.getData().add(data, dataOffset, length - dataOffset);
    }

    private /* synthetic */ void lambda$onNewMessage$0(sensor_msgs.CompressedImage ros1Image) {
        this.waitThenAct(ros1Image);
    }
}

