/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.simulationStarter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import us.ihmc.avatar.DRCStartingLocation;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessorParameters;
import us.ihmc.avatar.simulationStarter.SimulationStarterInterface;
import us.ihmc.commons.FormattingTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.robotEnvironmentAwareness.LidarBasedREAStandaloneLauncher;
import us.ihmc.robotEnvironmentAwareness.RemoteLidarBasedREAUILauncher;
import us.ihmc.tools.processManagement.JavaProcessSpawner;

public abstract class DRCSimulationTools {
    private static final String STARTING_LOCATION_PROPERTY_NAME = "startingLocation";

    public static <T extends DRCStartingLocation, Enum> void startSimulationWithGraphicSelector(SimulationStarterInterface simulationStarter, Class<?> operatorInterfaceClass, String[] operatorInterfaceArgs, T ... possibleStartingLocations) {
        ArrayList<Modules> modulesToStart = new ArrayList<Modules>();
        DRCStartingLocation startingLocation = DRCSimulationTools.showSelectorWithStartingLocation(modulesToStart, possibleStartingLocations);
        DRCSimulationTools.startSimulation(simulationStarter, operatorInterfaceClass, operatorInterfaceArgs, startingLocation, modulesToStart);
    }

    public static <T extends DRCStartingLocation, Enum> void startSimulation(SimulationStarterInterface simulationStarter, Class<?> operatorInterfaceClass, String[] operatorInterfaceArgs, DRCStartingLocation startingLocation, List<Modules> modulesToStart) {
        boolean startREAModule;
        HumanoidNetworkProcessorParameters networkProcessorParameters;
        if (startingLocation != null) {
            simulationStarter.setStartingLocation(startingLocation);
        }
        if (modulesToStart.isEmpty()) {
            return;
        }
        boolean automaticallyStartSimulation = true;
        if (modulesToStart.contains((Object)Modules.NETWORK_PROCESSOR)) {
            networkProcessorParameters = new HumanoidNetworkProcessorParameters();
            networkProcessorParameters.setUseBehaviorModule(modulesToStart.contains((Object)Modules.BEHAVIOR_MODULE), modulesToStart.contains((Object)Modules.BEHAVIOR_MODULE));
            networkProcessorParameters.setUseSensorModule(modulesToStart.contains((Object)Modules.SENSOR_MODULE));
            networkProcessorParameters.setUseZeroPoseRobotConfigurationPublisherModule(modulesToStart.contains((Object)Modules.ZERO_POSE_PRODUCER));
            networkProcessorParameters.setUseROSModule(modulesToStart.contains((Object)Modules.ROS_MODULE));
            networkProcessorParameters.setUseKinematicsToolboxModule(modulesToStart.contains((Object)Modules.KINEMATICS_TOOLBOX));
            networkProcessorParameters.setUseKinematicsStreamingToolboxModule(modulesToStart.contains((Object)Modules.KINEMATICS_TOOLBOX));
            networkProcessorParameters.setUseFootstepPlanningToolboxModule(modulesToStart.contains((Object)Modules.FOOTSTEP_PLANNING_TOOLBOX));
            networkProcessorParameters.setUseWholeBodyTrajectoryToolboxModule(modulesToStart.contains((Object)Modules.WHOLE_BODY_TRAJECTORY_TOOLBOX));
            networkProcessorParameters.setUseKinematicsPlanningToolboxModule(modulesToStart.contains((Object)Modules.KINEMATICS_PLANNING_TOOLBOX));
            startREAModule = modulesToStart.contains((Object)Modules.REA_MODULE) && !modulesToStart.contains((Object)Modules.REA_UI);
            networkProcessorParameters.setUseRobotEnvironmentAwerenessModule(startREAModule);
            networkProcessorParameters.setUseBipedalSupportPlanarRegionPublisherModule(modulesToStart.contains((Object)Modules.SENSOR_MODULE));
            networkProcessorParameters.setUseMocapModule(modulesToStart.contains((Object)Modules.MOCAP_MODULE));
            networkProcessorParameters.setUseFiducialDetectorToolboxModule(modulesToStart.contains((Object)Modules.FIDUCIAL_DETECTOR));
            networkProcessorParameters.setUseObjectDetectorToolboxModule(modulesToStart.contains((Object)Modules.OBJECT_DETECTOR));
            networkProcessorParameters.setUseDirectionalControlModule(modulesToStart.contains((Object)Modules.DIRECTIONAL_CONTROL_TOOLBOX));
        } else {
            networkProcessorParameters = null;
        }
        if (modulesToStart.contains((Object)Modules.SIMULATION)) {
            simulationStarter.startSimulation(networkProcessorParameters, automaticallyStartSimulation);
        }
        if (modulesToStart.contains((Object)Modules.OPERATOR_INTERFACE)) {
            if (modulesToStart.contains((Object)Modules.SIMULATION)) {
                DRCSimulationTools.startOpertorInterfaceUsingProcessSpawner(operatorInterfaceClass, operatorInterfaceArgs);
            } else {
                DRCSimulationTools.startOpertorInterface(operatorInterfaceClass, operatorInterfaceArgs);
            }
        }
        if (modulesToStart.contains((Object)Modules.BEHAVIOR_VISUALIZER)) {
            simulationStarter.startBehaviorVisualizer();
        }
        startREAModule = modulesToStart.contains((Object)Modules.REA_MODULE);
        boolean startREAUI = modulesToStart.contains((Object)Modules.REA_UI);
        if (startREAModule && startREAUI) {
            new JavaProcessSpawner(true, true).spawn(LidarBasedREAStandaloneLauncher.class);
        } else if (startREAUI) {
            new JavaProcessSpawner(true, true).spawn(RemoteLidarBasedREAUILauncher.class);
        }
    }

    private static <T extends DRCStartingLocation, Enum> DRCStartingLocation showSelectorWithStartingLocation(List<Modules> modulesToStartListToPack, T ... possibleStartingLocations) {
        JPanel userPromptPanel = new JPanel(new BorderLayout());
        JPanel checkBoxesPanel = new JPanel(new GridLayout(4, 3));
        String configFile = System.getProperty("user.home") + "/.ihmc/drcSimulationDefaultOptions.config";
        Properties properties = new Properties();
        try {
            FileInputStream lastConfigInputStream = new FileInputStream(configFile);
            properties.load(lastConfigInputStream);
            lastConfigInputStream.close();
        }
        catch (IOException lastConfigInputStream) {
            // empty catch block
        }
        JLabel userMessageLabel = new JLabel("Select which modules to start:");
        final EnumMap<Modules, JCheckBox> moduleCheckBoxes = new EnumMap<Modules, JCheckBox>(Modules.class);
        for (Modules module : Modules.values()) {
            boolean enabled = module.isAlwaysEnabled() ? true : Boolean.parseBoolean(properties.getProperty(module.getPropertyNameForEnable(), Boolean.toString(module.getDefaultValueForEnable())));
            boolean selected = Boolean.parseBoolean(properties.getProperty(module.getPropertyNameForSelected(), Boolean.toString(module.getDefaultValueForSelected())));
            JCheckBox checkBox = new JCheckBox(module.getName());
            checkBox.setSelected(selected);
            checkBox.setEnabled(enabled);
            checkBoxesPanel.add(checkBox);
            moduleCheckBoxes.put(module, checkBox);
        }
        ChangeListener networkProcessorCheckBoxChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isNetworkProcessorSelected = ((JCheckBox)moduleCheckBoxes.get((Object)Modules.NETWORK_PROCESSOR)).isSelected();
                boolean isNetworkProcessorEnabled = ((JCheckBox)moduleCheckBoxes.get((Object)Modules.NETWORK_PROCESSOR)).isEnabled();
                ((JCheckBox)moduleCheckBoxes.get((Object)Modules.BEHAVIOR_MODULE)).setEnabled(isNetworkProcessorSelected && isNetworkProcessorEnabled);
                ((JCheckBox)moduleCheckBoxes.get((Object)Modules.SENSOR_MODULE)).setEnabled(isNetworkProcessorSelected && isNetworkProcessorEnabled);
                ((JCheckBox)moduleCheckBoxes.get((Object)Modules.ZERO_POSE_PRODUCER)).setEnabled(isNetworkProcessorSelected && isNetworkProcessorEnabled);
                ((JCheckBox)moduleCheckBoxes.get((Object)Modules.ROS_MODULE)).setEnabled(isNetworkProcessorSelected && isNetworkProcessorEnabled);
                ((JCheckBox)moduleCheckBoxes.get((Object)Modules.REA_MODULE)).setEnabled(isNetworkProcessorSelected && isNetworkProcessorEnabled);
                ((JCheckBox)moduleCheckBoxes.get((Object)Modules.REA_UI)).setEnabled(isNetworkProcessorSelected && isNetworkProcessorEnabled);
                ((JCheckBox)moduleCheckBoxes.get((Object)Modules.DIRECTIONAL_CONTROL_TOOLBOX)).setEnabled(isNetworkProcessorSelected && isNetworkProcessorEnabled);
            }
        };
        ChangeListener simulationCheckBoxChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isSimulationSelected = ((JCheckBox)moduleCheckBoxes.get((Object)Modules.SIMULATION)).isSelected();
                ((JCheckBox)moduleCheckBoxes.get((Object)Modules.NETWORK_PROCESSOR)).setEnabled(isSimulationSelected);
            }
        };
        ((JCheckBox)moduleCheckBoxes.get((Object)Modules.NETWORK_PROCESSOR)).addChangeListener(networkProcessorCheckBoxChangeListener);
        ((JCheckBox)moduleCheckBoxes.get((Object)Modules.SIMULATION)).addChangeListener(simulationCheckBoxChangeListener);
        networkProcessorCheckBoxChangeListener.stateChanged(null);
        simulationCheckBoxChangeListener.stateChanged(null);
        JComboBox<T> obstacleCourseStartingLocationComboBox = null;
        if (possibleStartingLocations != null && possibleStartingLocations.length > 0) {
            JPanel comboBoxPanel = new JPanel(new BorderLayout());
            HashMap<Modules[], JComboBox<T>> comboBoxPanelsMap = new HashMap<Modules[], JComboBox<T>>();
            JLabel selectObstacleCourseLocationLabel = new JLabel("Select a Starting Location: ");
            JPanel locationPanel = new JPanel();
            locationPanel.setLayout(new BoxLayout(locationPanel, 3));
            Modules[] obstacleCourseLocationPanel = new JPanel(new BorderLayout());
            obstacleCourseLocationPanel.setVisible(true);
            obstacleCourseStartingLocationComboBox = new JComboBox<T>(possibleStartingLocations);
            HashMap<String, T> possibleStartingLocationMap = new HashMap<String, T>();
            for (T possibleStartingLocation : possibleStartingLocations) {
                possibleStartingLocationMap.put(possibleStartingLocation.toString(), possibleStartingLocation);
            }
            DRCStartingLocation selectedStartingLocation = (DRCStartingLocation)possibleStartingLocationMap.get(properties.getProperty(STARTING_LOCATION_PROPERTY_NAME, possibleStartingLocations[0].toString()));
            obstacleCourseStartingLocationComboBox.setSelectedItem(selectedStartingLocation == null ? possibleStartingLocations[0] : selectedStartingLocation);
            comboBoxPanelsMap.put(obstacleCourseLocationPanel, obstacleCourseStartingLocationComboBox);
            obstacleCourseLocationPanel.add((Component)selectObstacleCourseLocationLabel, "West");
            obstacleCourseLocationPanel.add(obstacleCourseStartingLocationComboBox, "East");
            obstacleCourseLocationPanel.setVisible(true);
            locationPanel.add((Component)obstacleCourseLocationPanel);
            comboBoxPanel.add((Component)locationPanel, "Center");
            userPromptPanel.add((Component)comboBoxPanel, "North");
        }
        userPromptPanel.add((Component)userMessageLabel, "Center");
        userPromptPanel.add((Component)checkBoxesPanel, "South");
        final JFrame frame = new JFrame("Launch");
        frame.setIconImage(new ImageIcon(DRCSimulationTools.class.getClassLoader().getResource("running-man-32x32-Launch.png")).getImage());
        frame.setLayout(new BorderLayout());
        frame.add((Component)userPromptPanel, "Center");
        JPanel optionPanel = new JPanel();
        final JButton okayButton = new JButton(new AbstractAction("Okay"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                frame.dispose();
                frame.setEnabled(false);
            }
        });
        optionPanel.add(okayButton);
        final JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(-1);
            }
        });
        optionPanel.add(cancelButton);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (frame.isVisible() && e.getID() == 400) {
                    if (e.getKeyChar() == '\n') {
                        okayButton.doClick();
                    } else if (e.getKeyChar() == '\u001b') {
                        cancelButton.doClick();
                    }
                    return true;
                }
                return false;
            }
        });
        frame.add((Component)optionPanel, "South");
        frame.pack();
        frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        frame.setLocationRelativeTo(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        while (frame.isEnabled()) {
            ThreadTools.sleep((long)50L);
        }
        properties = new Properties();
        for (Modules module : Modules.values()) {
            boolean selected = ((JCheckBox)moduleCheckBoxes.get((Object)module)).isSelected();
            boolean enabled = ((JCheckBox)moduleCheckBoxes.get((Object)module)).isEnabled();
            if (selected && enabled) {
                modulesToStartListToPack.add(module);
            }
            properties.setProperty(module.getPropertyNameForEnable(), String.valueOf(enabled));
            properties.setProperty(module.getPropertyNameForSelected(), String.valueOf(selected));
        }
        if (obstacleCourseStartingLocationComboBox != null && obstacleCourseStartingLocationComboBox.getSelectedItem() != null) {
            properties.setProperty(STARTING_LOCATION_PROPERTY_NAME, obstacleCourseStartingLocationComboBox.getSelectedItem().toString());
        }
        try {
            FileOutputStream newConfigOutputStream = new FileOutputStream(configFile);
            properties.store(newConfigOutputStream, "Default configuration for the graphic selector of the DRCSimulationTools");
            newConfigOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (obstacleCourseStartingLocationComboBox == null) {
            return null;
        }
        return (DRCStartingLocation)obstacleCourseStartingLocationComboBox.getSelectedItem();
    }

    public static void startOpertorInterfaceUsingProcessSpawner(Class<?> operatorInterfaceClass, String[] operatorInterfaceArgs) {
        JavaProcessSpawner spawner = new JavaProcessSpawner(true, true);
        if (operatorInterfaceClass == null) {
            return;
        }
        spawner.spawn(operatorInterfaceClass, operatorInterfaceArgs);
    }

    public static void startOpertorInterface(Class<?> operatorInterfaceClass, String[] operatorInterfaceArgs) {
        if (operatorInterfaceClass == null) {
            return;
        }
        try {
            Method mainMethod = operatorInterfaceClass.getDeclaredMethod("main", String[].class);
            Object[] args = new Object[]{operatorInterfaceArgs};
            mainMethod.invoke(null, args);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static enum Modules {
        SIMULATION,
        OPERATOR_INTERFACE,
        BEHAVIOR_VISUALIZER,
        NETWORK_PROCESSOR,
        SENSOR_MODULE,
        ROS_MODULE,
        BEHAVIOR_MODULE,
        ZERO_POSE_PRODUCER,
        REA_MODULE,
        REA_UI,
        MOCAP_MODULE,
        KINEMATICS_TOOLBOX,
        KINEMATICS_PLANNING_TOOLBOX,
        FOOTSTEP_PLANNING_TOOLBOX,
        WHOLE_BODY_TRAJECTORY_TOOLBOX,
        FIDUCIAL_DETECTOR,
        OBJECT_DETECTOR,
        DIRECTIONAL_CONTROL_TOOLBOX;


        public String getPropertyNameForEnable() {
            return "enable" + FormattingTools.underscoredToCamelCase((String)this.toString(), (boolean)true);
        }

        public String getPropertyNameForSelected() {
            return "select" + FormattingTools.underscoredToCamelCase((String)this.toString(), (boolean)true);
        }

        public boolean isAlwaysEnabled() {
            return this == SIMULATION || this == OPERATOR_INTERFACE || this == BEHAVIOR_VISUALIZER;
        }

        public boolean getDefaultValueForEnable() {
            return true;
        }

        public boolean getDefaultValueForSelected() {
            return this == SIMULATION || this == OPERATOR_INTERFACE || this == NETWORK_PROCESSOR || this == SENSOR_MODULE;
        }

        public String getName() {
            return FormattingTools.underscoredToCamelCase((String)this.toString(), (boolean)true);
        }
    }
}

