/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.stepAdjustment;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPlane;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintRegion;
import us.ihmc.robotics.RegionInWorldInterface;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class CapturabilityBasedPlanarRegionDecider {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double defaultMinimumIntersectionForSearch = 0.015;
    private static final double defaultAreaImprovementToSwitch = 0.02;
    private static final double defaultInflationToCurrentArea = 0.1;
    private final List<StepConstraintRegion> stepConstraintRegions = new ArrayList<StepConstraintRegion>();
    private final YoBoolean switchPlanarRegionConstraintsAutomatically;
    private final YoDouble minimumIntersectionForSearch;
    private final YoDouble areaImprovementToSwitch;
    private final YoDouble inflationToCurrentArea;
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
    private final YoBoolean constraintRegionChanged;
    private final YoDouble intersectionAreaWithCurrentRegion;
    private final ConvexPolygon2D convexHullConstraintInControlPlane = new ConvexPolygon2D();
    private final ConvexPolygon2D possibleArea = new ConvexPolygon2D();
    private final FrameConvexPolygon2D captureRegion = new FrameConvexPolygon2D();
    private final YoFrameConvexPolygon2D yoConvexHullConstraint;
    private final ICPControlPlane icpControlPlane;
    private StepConstraintRegion planarRegionToConstrainTo = null;

    public CapturabilityBasedPlanarRegionDecider(ReferenceFrame centerOfMassFrame, double gravityZ, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.icpControlPlane = new ICPControlPlane(centerOfMassFrame, gravityZ, registry);
        this.constraintRegionChanged = new YoBoolean("constraintRegionChanged", registry);
        this.intersectionAreaWithCurrentRegion = new YoDouble("intersectionAreaWithCurrentRegion", registry);
        this.minimumIntersectionForSearch = new YoDouble("minimumIntersectionForSearch", registry);
        this.areaImprovementToSwitch = new YoDouble("areaImprovementToSwitch", registry);
        this.inflationToCurrentArea = new YoDouble("inflationToCurrentArea", registry);
        this.minimumIntersectionForSearch.set(0.015);
        this.areaImprovementToSwitch.set(0.02);
        this.inflationToCurrentArea.set(0.1);
        this.switchPlanarRegionConstraintsAutomatically = new YoBoolean("switchPlanarRegionConstraintsAutomatically", registry);
        this.yoConvexHullConstraint = new YoFrameConvexPolygon2D("convexHullConstraint", "", worldFrame, 12, registry);
        if (yoGraphicsListRegistry != null) {
            YoArtifactPolygon activePlanarRegionViz = new YoArtifactPolygon("ConvexHullConstraint", this.yoConvexHullConstraint, Color.RED, false);
            yoGraphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)activePlanarRegionViz);
        }
    }

    public void setConstraintRegions(List<StepConstraintRegion> constraintRegions) {
        this.stepConstraintRegions.clear();
        this.stepConstraintRegions.addAll(constraintRegions);
    }

    public void setCaptureRegion(FrameConvexPolygon2DReadOnly captureRegion) {
        this.captureRegion.setIncludingFrame((FrameVertex2DSupplier)captureRegion);
    }

    public void setOmega0(double omega) {
        this.icpControlPlane.setOmega0(omega);
    }

    public void setSwitchPlanarRegionConstraintsAutomatically(boolean switchAutomatically) {
        this.switchPlanarRegionConstraintsAutomatically.set(switchAutomatically);
    }

    public void reset() {
        this.planarRegionToConstrainTo = null;
        this.intersectionAreaWithCurrentRegion.set(0.0);
        this.yoConvexHullConstraint.clear();
    }

    private void computeProjectedConvexHull(StepConstraintRegion constraintRegion) {
        this.yoConvexHullConstraint.set((Vertex2DSupplier)constraintRegion.getConvexHullInConstraintRegion());
        this.yoConvexHullConstraint.applyTransform((Transform)constraintRegion.getTransformToWorld(), false);
        this.icpControlPlane.projectVerticesOntoControlPlane((Vertex2DSupplier)constraintRegion.getConvexHullInConstraintRegion(), constraintRegion.getTransformToWorld(), (ConvexPolygon2DBasics)this.convexHullConstraintInControlPlane);
    }

    public StepConstraintRegion updatePlanarRegionConstraintForStep(FramePose3DReadOnly footstepPose, ConvexPolygon2DReadOnly reachabilityInControlPlane) {
        StepConstraintRegion betterRegion;
        this.constraintRegionChanged.set(false);
        this.captureRegion.changeFrameAndProjectToXYPlane(worldFrame);
        if (this.planarRegionToConstrainTo == null) {
            this.planarRegionToConstrainTo = this.findPlanarRegionUnderFoothold(footstepPose.getPosition());
            if (this.planarRegionToConstrainTo != null) {
                this.computeProjectedConvexHull(this.planarRegionToConstrainTo);
                this.constraintRegionChanged.set(true);
            }
        }
        if (this.switchPlanarRegionConstraintsAutomatically.getBooleanValue() && !this.checkIfCurrentPlanarRegionIsValid((FrameConvexPolygon2DReadOnly)this.captureRegion, reachabilityInControlPlane) && (betterRegion = this.findBestPlanarRegionToStepTo((FrameConvexPolygon2DReadOnly)this.captureRegion, reachabilityInControlPlane)) != null && betterRegion != this.planarRegionToConstrainTo) {
            this.planarRegionToConstrainTo = betterRegion;
            this.computeProjectedConvexHull(this.planarRegionToConstrainTo);
            this.constraintRegionChanged.set(true);
        }
        return this.planarRegionToConstrainTo;
    }

    public boolean constraintRegionChanged() {
        return this.constraintRegionChanged.getBooleanValue();
    }

    public void setConstraintRegionChanged(boolean constraintRegionChanged) {
        this.constraintRegionChanged.set(constraintRegionChanged);
    }

    public StepConstraintRegion getConstraintRegion() {
        return this.planarRegionToConstrainTo;
    }

    private StepConstraintRegion findPlanarRegionUnderFoothold(FramePoint3DReadOnly foothold) {
        StepConstraintRegion highestRegionUnderFoot = new StepConstraintRegion();
        Point3D projectedPoint = PlanarRegionTools.projectPointToPlanesVertically((Point3DReadOnly)foothold, this.stepConstraintRegions, (RegionInWorldInterface)highestRegionUnderFoot);
        return projectedPoint == null ? null : highestRegionUnderFoot;
    }

    private boolean checkIfCurrentPlanarRegionIsValid(FrameConvexPolygon2DReadOnly captureRegion, ConvexPolygon2DReadOnly reachabilityRegion) {
        if (this.planarRegionToConstrainTo == null) {
            return false;
        }
        this.computeProjectedConvexHull(this.planarRegionToConstrainTo);
        if (reachabilityRegion != null) {
            this.convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)this.convexHullConstraintInControlPlane, reachabilityRegion, (ConvexPolygon2DBasics)this.possibleArea);
        } else {
            this.possibleArea.set(this.convexHullConstraintInControlPlane);
        }
        this.intersectionAreaWithCurrentRegion.set(this.convexPolygonTools.computeIntersectionAreaOfPolygons((ConvexPolygon2DReadOnly)captureRegion, (ConvexPolygon2DReadOnly)this.possibleArea));
        return this.intersectionAreaWithCurrentRegion.getDoubleValue() > this.minimumIntersectionForSearch.getDoubleValue();
    }

    private StepConstraintRegion findBestPlanarRegionToStepTo(FrameConvexPolygon2DReadOnly captureRegion, ConvexPolygon2DReadOnly reachabilityRegion) {
        double maxArea = this.intersectionAreaWithCurrentRegion.getDoubleValue();
        if (maxArea > 0.0) {
            maxArea = (1.0 + this.inflationToCurrentArea.getDoubleValue()) * maxArea + this.areaImprovementToSwitch.getDoubleValue();
        }
        StepConstraintRegion activePlanarRegion = this.planarRegionToConstrainTo;
        for (int regionIndex = 0; regionIndex < this.stepConstraintRegions.size(); ++regionIndex) {
            double intersectionArea;
            StepConstraintRegion constraintRegion = this.stepConstraintRegions.get(regionIndex);
            if (constraintRegion == activePlanarRegion || !((intersectionArea = this.findIntersectionAreaWithCaptureRegion(captureRegion, reachabilityRegion, constraintRegion)) > maxArea)) continue;
            maxArea = intersectionArea;
            activePlanarRegion = constraintRegion;
        }
        return activePlanarRegion;
    }

    private double findIntersectionAreaWithCaptureRegion(FrameConvexPolygon2DReadOnly captureRegionInControlPlane, ConvexPolygon2DReadOnly reachabilityRegion, StepConstraintRegion constraintRegion) {
        this.icpControlPlane.projectVerticesOntoControlPlane((Vertex2DSupplier)constraintRegion.getConcaveHull(), constraintRegion.getTransformToWorld(), (ConvexPolygon2DBasics)this.convexHullConstraintInControlPlane);
        if (reachabilityRegion != null) {
            this.convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)this.convexHullConstraintInControlPlane, reachabilityRegion, (ConvexPolygon2DBasics)this.possibleArea);
        } else {
            this.possibleArea.set(this.convexHullConstraintInControlPlane);
        }
        double intersectionArea = this.convexPolygonTools.computeIntersectionAreaOfPolygons((ConvexPolygon2DReadOnly)captureRegionInControlPlane, (ConvexPolygon2DReadOnly)this.possibleArea);
        for (ConcavePolygon2DReadOnly convexPolygon : constraintRegion.getHolesInConstraintRegion()) {
            this.icpControlPlane.projectVerticesOntoControlPlane((Vertex2DSupplier)convexPolygon, constraintRegion.getTransformToWorld(), (ConvexPolygon2DBasics)this.convexHullConstraintInControlPlane);
            if (reachabilityRegion != null) {
                this.convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)this.convexHullConstraintInControlPlane, reachabilityRegion, (ConvexPolygon2DBasics)this.possibleArea);
            } else {
                this.possibleArea.set(this.convexHullConstraintInControlPlane);
            }
            intersectionArea -= this.convexPolygonTools.computeIntersectionAreaOfPolygons((ConvexPolygon2DReadOnly)captureRegionInControlPlane, (ConvexPolygon2DReadOnly)this.possibleArea);
        }
        return intersectionArea;
    }
}

