/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.stepAdjustment;

import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ReachabilityConstraintCalculator {
    private static final double distanceInsideRegion = 0.04;
    private static final int numberOfVertices = 5;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble lengthLimit;
    private final YoDouble lengthBackLimit;
    private final YoDouble innerLimit;
    private final YoDouble outerLimit;
    private final SideDependentList<? extends ReferenceFrame> soleZUpFrames;

    public ReachabilityConstraintCalculator(SideDependentList<? extends ReferenceFrame> soleZUpFrames, SteppingParameters steppingParameters, YoRegistry parentRegistry) {
        this(soleZUpFrames, steppingParameters.getFootLength(), steppingParameters.getFootWidth(), steppingParameters.getMaxStepLength(), steppingParameters.getMaxBackwardStepLength(), steppingParameters.getMinStepWidth(), steppingParameters.getMaxStepWidth(), parentRegistry);
    }

    public ReachabilityConstraintCalculator(SideDependentList<? extends ReferenceFrame> soleZUpFrames, double footLength, double footWidth, double maxStepLength, double maxBackwardStepLength, double minStepWidth, double maxStepWidth, YoRegistry parentRegistry) {
        this.soleZUpFrames = soleZUpFrames;
        this.lengthLimit = new YoDouble("MaxReachabilityLength", this.registry);
        this.lengthBackLimit = new YoDouble("MaxReachabilityBackwardLength", this.registry);
        this.innerLimit = new YoDouble("MinReachabilityWidth", this.registry);
        this.outerLimit = new YoDouble("MaxReachabilityWidth", this.registry);
        this.lengthLimit.set(maxStepLength + 0.5 * footLength + 0.04);
        this.lengthBackLimit.set(maxBackwardStepLength + 0.5 * footLength + 0.04);
        this.innerLimit.set(minStepWidth - 0.5 * footWidth - 0.04);
        this.outerLimit.set(maxStepWidth + 0.5 * footWidth + 0.04);
        parentRegistry.addChild(this.registry);
    }

    public FrameConvexPolygon2DReadOnly getReachabilityPolygon(RobotSide supportSide) {
        FrameConvexPolygon2D polygon = new FrameConvexPolygon2D((ReferenceFrame)this.soleZUpFrames.get((Enum)supportSide));
        double xRadius = 0.5 * (this.lengthLimit.getValue() + this.lengthBackLimit.getValue());
        double yRadius = this.outerLimit.getValue() - this.innerLimit.getValue();
        double centerX = this.lengthLimit.getValue() - xRadius;
        double centerY = this.innerLimit.getValue();
        for (int vertexIdx = 0; vertexIdx < 5; ++vertexIdx) {
            double angle = Math.PI * (double)vertexIdx / 4.0;
            double x = centerX + xRadius * Math.cos(angle);
            double y = centerY + yRadius * Math.sin(angle);
            polygon.addVertex(x, supportSide.negateIfLeftSide(y));
        }
        polygon.update();
        polygon.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        return polygon;
    }
}

