/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.stepAdjustment;

import controller_msgs.msg.dds.FootstepStatusMessage;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;

public class SimpleStep {
    private RobotSide swingSide;
    private double swingDuration;
    private double startTime;
    private FramePose3D stepPose = new FramePose3D();

    public SimpleStep() {
    }

    public SimpleStep(FootstepStatusMessage statusMessage, double startTime) {
        this.setSwingSide(RobotSide.fromByte((byte)statusMessage.getRobotSide()));
        this.setSwingDuration(statusMessage.getSwingDuration());
        this.setStartTime(startTime);
        this.setStepPose((Point3DReadOnly)statusMessage.getDesiredFootPositionInWorld(), (Orientation3DReadOnly)statusMessage.getDesiredFootOrientationInWorld());
    }

    public void setSwingSide(RobotSide swingSide) {
        this.swingSide = swingSide;
    }

    public void setSwingDuration(double swingDuration) {
        this.swingDuration = swingDuration;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public void setStepPose(Pose3DReadOnly stepPose) {
        this.setStepPose(stepPose.getPosition(), (Orientation3DReadOnly)stepPose.getOrientation());
    }

    public void setStepPose(Point3DReadOnly stepPosition, Orientation3DReadOnly stepOrientation) {
        this.setStepPosition(stepPosition);
        this.setStepOrientation(stepOrientation);
    }

    public void setStepPosition(Point3DReadOnly stepPosition) {
        this.stepPose.getPosition().set((Tuple3DReadOnly)stepPosition);
    }

    public void setStepOrientation(Orientation3DReadOnly stepOrientation) {
        this.stepPose.getOrientation().set(stepOrientation);
    }

    public double getSwingDuration() {
        return this.swingDuration;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public RobotSide getSwingSide() {
        return this.swingSide;
    }

    public FramePose3DReadOnly getStepPose() {
        return this.stepPose;
    }
}

