/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import us.ihmc.commons.MathTools;

public class InterpolationTools {
    public static double piecewiseInterpolate(double a, double b, double alpha) {
        if (alpha < 0.5) {
            return a;
        }
        return b;
    }

    public static double piecewiseInterpolateRoundDown(double a, double b, double alpha) {
        if (alpha > 0.5) {
            return b;
        }
        return a;
    }

    public static double linearInterpolate(double a, double b, double alpha) {
        return (1.0 - alpha) * a + alpha * b;
    }

    public static double hermite01Interpolate(double a, double b, double alpha) {
        double beta = InterpolationTools.hermite01Coefficient(alpha);
        return InterpolationTools.linearInterpolate(a, b, beta);
    }

    public static double hermiteInterpolate(double a, double b, double alpha) throws IllegalArgumentException {
        alpha = MathTools.clamp(alpha, 0.0, 1.0);
        double h00 = InterpolationTools.hermite00Coefficient(alpha);
        double h01 = InterpolationTools.hermite01Coefficient(alpha);
        return h00 * a + h01 * b;
    }

    public static double hermiteInterpolate(double a, double aTangent, double b, double bTangent, double alpha) throws IllegalArgumentException {
        alpha = MathTools.clamp(alpha, 0.0, 1.0);
        double h00 = InterpolationTools.hermite00Coefficient(alpha);
        double h10 = InterpolationTools.hermite10Coefficient(alpha);
        double h01 = InterpolationTools.hermite01Coefficient(alpha);
        double h11 = InterpolationTools.hermite11Coefficient(alpha);
        return h00 * a + h10 * aTangent + h01 * b + h11 * bTangent;
    }

    public static double hermite00Coefficient(double alpha) {
        return 2.0 * Math.pow(alpha, 3.0) - 3.0 * Math.pow(alpha, 2.0) + 1.0;
    }

    public static double hermite10Coefficient(double alpha) {
        return Math.pow(alpha, 3.0) - 2.0 * Math.pow(alpha, 2.0) + alpha;
    }

    public static double hermite01Coefficient(double alpha) {
        return -2.0 * Math.pow(alpha, 3.0) + 3.0 * Math.pow(alpha, 2.0);
    }

    public static double hermite11Coefficient(double alpha) {
        return Math.pow(alpha, 3.0) - Math.pow(alpha, 2.0);
    }

    public static double logisticInterpolate(double a, double b, double alpha) {
        return InterpolationTools.logisticInterpolate(a, b, alpha, 1.0);
    }

    public static double logisticInterpolate(double a, double b, double alpha, double steepness) {
        double value = 12.0 * alpha - 6.0;
        double beta = 1.0 / (1.0 + Math.exp(-steepness * value));
        return InterpolationTools.linearInterpolate(a, b, beta);
    }
}

