/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;

public class MathTools {
    public static double average(double[] array) {
        return MathTools.sum(array) / (double)array.length;
    }

    public static double average(List<Double> list) {
        return MathTools.sum(list) / (double)list.size();
    }

    public static double ceilToPrecision(double value, double precision) {
        return Math.ceil(value / precision) * precision;
    }

    public static void checkEpsilonEquals(double value1, double value2, double epsilon) {
        if (!MathTools.epsilonEquals(value1, value2, epsilon)) {
            throw new RuntimeException("Not epsilon equal.  " + value1 + " != " + value2 + " +/- " + epsilon);
        }
    }

    public static void checkEquals(int value1, int value2) {
        if (value1 != value2) {
            throw new RuntimeException("Not equal. " + value1 + " !=" + value2);
        }
    }

    public static void checkGreaterThanOrEquals(double greater, double lesser) {
        if (greater < lesser) {
            throw new RuntimeException("Not greater than or equal. " + greater + " < " + lesser);
        }
    }

    public static void checkIntervalContains(double value, double lowerEndpoint, double upperEndpoint) {
        if (!MathTools.intervalContains(value, lowerEndpoint, upperEndpoint)) {
            throw new RuntimeException("Argument " + value + " not in range [" + lowerEndpoint + ", " + upperEndpoint + "].");
        }
    }

    public static void checkIntervalContains(long value, long lowerEndpoint, long upperEndpoint) {
        if (!MathTools.intervalContains(value, lowerEndpoint, upperEndpoint)) {
            throw new RuntimeException("Argument " + value + " not in range [" + lowerEndpoint + ", " + upperEndpoint + "].");
        }
    }

    public static void checkLessThanOrEquals(double lesser, double greater) {
        if (lesser > greater) {
            throw new RuntimeException("Not less than or equal. " + lesser + " > " + greater);
        }
    }

    public static void checkNegative(double value) {
        if (value > 0.0) {
            throw new RuntimeException("Value " + value + " is positive.");
        }
    }

    public static void checkPositive(double value) {
        if (value < 0.0) {
            throw new RuntimeException("Value " + value + " is negative.");
        }
    }

    public static double clamp(double value, double minMax) {
        return MathTools.clamp(value, -minMax, minMax);
    }

    public static double clamp(double value, double min, double max) {
        if (min > max + 1.0E-10) {
            throw new RuntimeException(MathTools.class.getSimpleName() + ".clamp(double, double, double): min > max (" + min + " > " + max + ")");
        }
        return Math.min(max, Math.max(value, min));
    }

    public static int clamp(int value, int minMax) {
        return MathTools.clamp(value, -minMax, minMax);
    }

    public static int clamp(int value, int min, int max) {
        if (min > max) {
            throw new RuntimeException(MathTools.class.getSimpleName() + ".clamp(int, int, int): min > max (" + min + " > " + max + ")");
        }
        return Math.min(max, Math.max(value, min));
    }

    public static long clamp(long value, long minMax) {
        return MathTools.clamp(value, -minMax, minMax);
    }

    public static long clamp(long value, long min, long max) {
        if (min > max) {
            throw new RuntimeException(MathTools.class.getSimpleName() + ".clamp(long, long, long): min > max (" + min + " > " + max + ")");
        }
        return Math.min(max, Math.max(value, min));
    }

    public static double cube(double value) {
        return value * value * value;
    }

    public static double[] cumulativeSum(double[] array) {
        double[] ret = new double[array.length];
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            ret[i] = sum += array[i];
        }
        return ret;
    }

    public static double[] diff(double[] array) {
        double[] ret = new double[array.length - 1];
        for (int i = 1; i < array.length; ++i) {
            ret[i - 1] = array[i] - array[i - 1];
        }
        return ret;
    }

    public static double[] dotPlus(double[] array, double addToAllElementsOfA) {
        double[] ret = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = array[i] + addToAllElementsOfA;
        }
        return ret;
    }

    public static int[] dotPlus(int[] array, int addToAllElementsOfA) {
        int[] ret = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = array[i] + addToAllElementsOfA;
        }
        return ret;
    }

    public static boolean epsilonCompare(double a, double b, double epsilon) {
        if (epsilon < 0.0) {
            throw new RuntimeException("epilson is less than 0.0");
        }
        if (Double.compare(a, b) == 0) {
            return true;
        }
        return Math.abs(a - b) <= epsilon;
    }

    public static boolean epsilonEquals(double a, double b, double epsilon) {
        if (epsilon < 0.0) {
            throw new RuntimeException("epilson is less than 0.0");
        }
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return false;
        }
        if (Double.compare(a, b) == 0) {
            return true;
        }
        return Math.abs(a - b) <= epsilon;
    }

    public static double floorToPrecision(double value, double precision) {
        return Math.floor(value / precision) * precision;
    }

    public static long gcd(long a, long b) {
        while (b > 0L) {
            long c = a % b;
            a = b;
            b = c;
        }
        return a;
    }

    public static boolean intervalContains(double value, double endpointMinMax) {
        return MathTools.intervalContains(value, -endpointMinMax, endpointMinMax);
    }

    public static boolean intervalContains(double value, double lowerEndpoint, double upperEndpoint) {
        return MathTools.intervalContains(value, lowerEndpoint, upperEndpoint, true, true);
    }

    public static boolean intervalContains(double value, double lowerEndpoint, double upperEndpoint, boolean includeLowerEndpoint, boolean includeUpperEndpoint) {
        if (lowerEndpoint > upperEndpoint + 1.0E-10) {
            throw new RuntimeException(MathTools.class.getSimpleName() + ".intervalContains(double, double, double, boolean, boolean): lowerEndpoint > upperEndpoint (" + lowerEndpoint + " > " + upperEndpoint + ")");
        }
        return (includeLowerEndpoint ? value >= lowerEndpoint : value > lowerEndpoint + 1.0E-10) && (includeUpperEndpoint ? value <= upperEndpoint : value < upperEndpoint - 1.0E-10);
    }

    public static boolean intervalContains(double value, double lowerEndpoint, double upperEndpoint, double precision) {
        return MathTools.intervalContains(MathTools.roundToPrecision(value, precision), MathTools.roundToPrecision(lowerEndpoint, precision), MathTools.roundToPrecision(upperEndpoint, precision));
    }

    public static boolean intervalContains(double value, double lowerEndpoint, double upperEndpoint, double precision, boolean includeLowerEndpoint, boolean includeUpperEndpoint) {
        return MathTools.intervalContains(MathTools.roundToPrecision(value, precision), MathTools.roundToPrecision(lowerEndpoint, precision), MathTools.roundToPrecision(upperEndpoint, precision), includeLowerEndpoint, includeUpperEndpoint);
    }

    public static boolean isGreaterThanOrEqualToWithPrecision(double a, double b, double precision) {
        return MathTools.roundToPrecision(a, precision) >= MathTools.roundToPrecision(b, precision);
    }

    public static boolean isGreaterThanOrEqualToWithSignificantFigures(double a, double b, int significantFigures) {
        return MathTools.roundToSignificantFigures(a, significantFigures) >= MathTools.roundToSignificantFigures(b, significantFigures);
    }

    public static boolean isGreaterThanWithPrecision(double a, double b, double precision) {
        return MathTools.roundToPrecision(a, precision) > MathTools.roundToPrecision(b, precision);
    }

    public static boolean isGreaterThanWithSignificantFigures(double a, double b, int significantFigures) {
        return MathTools.roundToSignificantFigures(a, significantFigures) > MathTools.roundToSignificantFigures(b, significantFigures);
    }

    public static boolean isLessThanOrEqualToWithPrecision(double a, double b, double precision) {
        return MathTools.roundToPrecision(a, precision) <= MathTools.roundToPrecision(b, precision);
    }

    public static boolean isLessThanOrEqualToWithSignificantFigures(double a, double b, int significantFigures) {
        return MathTools.roundToSignificantFigures(a, significantFigures) <= MathTools.roundToSignificantFigures(b, significantFigures);
    }

    public static boolean isLessThanWithPrecision(double a, double b, double precision) {
        return MathTools.roundToPrecision(a, precision) < MathTools.roundToPrecision(b, precision);
    }

    public static boolean isLessThanWithSignificantFigures(double a, double b, int significantFigures) {
        return MathTools.roundToSignificantFigures(a, significantFigures) < MathTools.roundToSignificantFigures(b, significantFigures);
    }

    public static long lcm(long ... a) {
        if (a.length < 2) {
            throw new RuntimeException("Need at least two arguments");
        }
        if (a.length == 2) {
            return Math.abs(a[0] * a[1]) / MathTools.gcd(a[0], a[1]);
        }
        long[] b = new long[a.length - 1];
        System.arraycopy(a, 1, b, 0, b.length);
        return MathTools.lcm(a[0], MathTools.lcm(b));
    }

    public static double max(double[] array) {
        double max = -1.7976931348623157E308;
        for (int i = 0; i < array.length; ++i) {
            max = Math.max(max, array[i]);
        }
        return max;
    }

    public static double min(double[] array) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            min = Math.min(min, array[i]);
        }
        return min;
    }

    public static int orderOfMagnitude(double number) {
        return (int)Math.floor(Math.log10(Math.abs(number)));
    }

    public static boolean percentEquals(double a, double b, double percent) {
        return MathTools.epsilonEquals(a, b, Math.abs(percent * a));
    }

    public static double pow(double value, int exponent) {
        double pow = 1.0;
        if (exponent >= 0) {
            for (int i = 0; i < exponent; ++i) {
                pow *= value;
            }
        } else {
            for (int i = 0; i > exponent; --i) {
                pow /= value;
            }
        }
        return pow;
    }

    public static double roundToPrecision(double value, double precision) {
        return (double)Math.round(value / precision) * precision;
    }

    public static double roundToSignificantFigures(double value, int significantFigures) {
        if (Math.abs(value) < Double.MIN_VALUE) {
            return 0.0;
        }
        return new BigDecimal(value, new MathContext(significantFigures, RoundingMode.HALF_UP)).doubleValue();
    }

    public static double sign(double argument) {
        if (argument >= 0.0) {
            return 1.0;
        }
        return -1.0;
    }

    public static double square(double value) {
        return value * value;
    }

    public static double sum(double[] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static int sum(int[] array) {
        int sum = 0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static double sum(List<Double> list) {
        double sum = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            sum += list.get(i).doubleValue();
        }
        return sum;
    }

    private MathTools() {
    }
}

