/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.thread;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;

public class ThreadTools {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    public static final int REASONABLE_WAITING_SLEEP_DURATION_MS = 10;
    private static final long ONE_MILLION = 1000000L;

    public static long sleepSeconds(double secondsToSleep) {
        return ThreadTools.sleep((long)(secondsToSleep * 1000.0));
    }

    public static long sleep(long millisecondsToSleep) {
        return ThreadTools.sleep(millisecondsToSleep, 0);
    }

    public static long sleep(long millisecondsToSleep, int additionalNanosecondsToSleep) {
        long startTimeNanos = System.nanoTime();
        long desiredSleepNanos = millisecondsToSleep * 1000000L + (long)additionalNanosecondsToSleep;
        boolean doneSleeping = false;
        long nanosSleptSoFar = 0L;
        while (!doneSleeping) {
            try {
                Thread.sleep(millisecondsToSleep, additionalNanosecondsToSleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            nanosSleptSoFar = System.nanoTime() - startTimeNanos;
            if (nanosSleptSoFar >= desiredSleepNanos) {
                doneSleeping = true;
                continue;
            }
            long nanosRemaining = desiredSleepNanos - nanosSleptSoFar;
            millisecondsToSleep = nanosRemaining / 1000000L;
            additionalNanosecondsToSleep = (int)(nanosRemaining - millisecondsToSleep * 1000000L);
        }
        return nanosSleptSoFar;
    }

    public static void sleepForever() {
        while (true) {
            ThreadTools.sleep(1000L);
        }
    }

    public static void join() {
        ThreadTools.join(DefaultExceptionHandler.PRINT_STACKTRACE);
    }

    public static void join(ExceptionHandler exceptionHandler) {
        ExceptionTools.handle(() -> Thread.currentThread().join(), exceptionHandler);
    }

    public static Thread startAThread(Runnable runnable, String threadName) {
        Thread newThread = new Thread(runnable, threadName);
        newThread.start();
        return newThread;
    }

    public static Thread startAsDaemon(Runnable daemonThreadRunnable, String threadName) {
        Thread daemonThread = new Thread(daemonThreadRunnable, threadName);
        daemonThread.setDaemon(true);
        daemonThread.start();
        return daemonThread;
    }

    public static void waitUntilNextMultipleOf(long waitMultipleMS) throws InterruptedException {
        ThreadTools.waitUntilNextMultipleOf(waitMultipleMS, 0L);
    }

    public static void waitUntilNextMultipleOf(long waitMultipleMS, long moduloOffset) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        long numberOfMultiplesThusFar = (startTime - moduloOffset) / waitMultipleMS;
        long endTime = (numberOfMultiplesThusFar + 1L) * waitMultipleMS + moduloOffset;
        ThreadTools.waitUntil(endTime);
    }

    public static void waitUntil(long endTime) throws InterruptedException {
        while (endTime > System.currentTimeMillis()) {
            Thread.sleep(10L);
        }
    }

    public static ThreadFactory getNamedThreadFactory(String name) {
        return ThreadTools.createNamedThreadFactory(name);
    }

    public static ThreadFactory createNamedThreadFactory(String prefix) {
        boolean includePoolInName = true;
        boolean includeThreadNumberInName = true;
        boolean daemon = false;
        return ThreadTools.createNamedThreadFactory(prefix, includePoolInName, includeThreadNumberInName, daemon, 5);
    }

    public static ThreadFactory createNamedDaemonThreadFactory(String prefix) {
        boolean includePoolInName = true;
        boolean includeThreadNumberInName = true;
        boolean daemon = true;
        return ThreadTools.createNamedThreadFactory(prefix, includePoolInName, includeThreadNumberInName, daemon, 5);
    }

    public static ThreadFactory createNamedThreadFactory(final String prefix, final boolean includePoolInName, final boolean includeThreadNumberInName, final boolean daemon, final int priority) {
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);
            private final ThreadGroup group;
            {
                SecurityManager s = System.getSecurityManager();
                this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
                poolNumber.getAndIncrement();
            }

            @Override
            public Thread newThread(Runnable runnable) {
                this.threadNumber.getAndIncrement();
                String threadName = prefix;
                if (includePoolInName) {
                    threadName = threadName + "-pool-" + poolNumber.get();
                }
                if (includeThreadNumberInName) {
                    threadName = threadName + "-thread-" + this.threadNumber.get();
                }
                Thread newThread = new Thread(this.group, runnable, threadName);
                newThread.setDaemon(daemon);
                newThread.setPriority(priority);
                return newThread;
            }
        };
    }

    public static ExecutorService newSingleThreadExecutor(String prefix) {
        return Executors.newSingleThreadExecutor(ThreadTools.createNamedThreadFactory(prefix));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String prefix) {
        return Executors.newSingleThreadScheduledExecutor(ThreadTools.createNamedThreadFactory(prefix));
    }

    public static ExecutorService newSingleDaemonThreadExecutor(String prefix) {
        return Executors.newSingleThreadExecutor(ThreadTools.createNamedDaemonThreadFactory(prefix));
    }

    public static ScheduledExecutorService newSingleDaemonThreadScheduledExecutor(String prefix) {
        return Executors.newSingleThreadScheduledExecutor(ThreadTools.createNamedDaemonThreadFactory(prefix));
    }

    public static String getBaseClassName() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String className = stack[stack.length - 1].getClassName();
        return className;
    }

    public static String getBaseSimpleClassName() {
        String baseClassName = ThreadTools.getBaseClassName();
        int lastDotIndex = baseClassName.lastIndexOf(46);
        String simpleClassName = baseClassName.substring(lastDotIndex + 1);
        return simpleClassName;
    }

    public static void interruptLiveThreadsExceptThisOneContaining(String stringToContain) {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        Set<Thread> threadSet = allStackTraces.keySet();
        for (Thread thread : threadSet) {
            if (!thread.isAlive() || thread == Thread.currentThread() || !thread.getName().contains(stringToContain)) continue;
            thread.interrupt();
        }
    }

    public static void interruptAllAliveThreadsExceptThisOne() {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        Set<Thread> threadSet = allStackTraces.keySet();
        for (Thread thread : threadSet) {
            if (!thread.isAlive() || thread == Thread.currentThread()) continue;
            thread.interrupt();
        }
    }

    public static ExecutorService executeWithTimeout(String threadName, Runnable runnable, long timeLimit, TimeUnit timeUnit) {
        ExecutorService executor = Executors.newSingleThreadExecutor(ThreadTools.createNamedThreadFactory(threadName));
        executor.execute(runnable);
        executor.shutdown();
        try {
            executor.awaitTermination(timeLimit, timeUnit);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return executor;
    }

    public static ScheduledFuture<?> scheduleWithFixeDelayAndTimeLimit(String threadName, Runnable runnable, long initialDelay, long delay, TimeUnit timeUnit, long timeLimit) {
        return ThreadTools.scheduleWithFixeDelayAndTimeLimit(threadName, runnable, initialDelay, delay, timeUnit, timeLimit, true);
    }

    public static ScheduledFuture<?> scheduleWithFixeDelayAndTimeLimit(String threadName, Runnable runnable, long initialDelay, long delay, TimeUnit timeUnit, long timeLimit, boolean interruptAtTimeLimit) {
        ScheduledFuture futureToReturn;
        if (interruptAtTimeLimit) {
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2, ThreadTools.getNamedThreadFactory(threadName));
            futureToReturn = scheduler.scheduleWithFixedDelay(runnable, initialDelay, delay, timeUnit);
            scheduler.schedule(() -> {
                boolean cancel = futureToReturn.cancel(true);
                LogTools.info((String)"Cancel: {}", (Object)cancel);
                return cancel;
            }, timeLimit, timeUnit);
        } else {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(ThreadTools.createNamedThreadFactory(threadName));
            AtomicReference handleHolder = new AtomicReference();
            double timeLimitSeconds = Conversions.nanosecondsToSeconds(timeUnit.toNanos(timeLimit));
            Stopwatch stopwatch = new Stopwatch().start();
            handleHolder.set(scheduler.scheduleWithFixedDelay(() -> {
                ScheduledFuture scheduledFuture;
                if (stopwatch.lapElapsed() < timeLimitSeconds) {
                    runnable.run();
                }
                if (stopwatch.lapElapsed() >= timeLimitSeconds && (scheduledFuture = (ScheduledFuture)handleHolder.get()) != null) {
                    scheduledFuture.cancel(true);
                }
            }, initialDelay, delay, timeUnit));
            futureToReturn = (ScheduledFuture)handleHolder.get();
        }
        return futureToReturn;
    }

    public static ScheduledFuture<?> scheduleSingleExecution(String threadName, Runnable runnable, double delay) {
        return ThreadTools.scheduleSingleExecution(threadName, runnable, Conversions.secondsToNanoseconds(delay), TimeUnit.NANOSECONDS);
    }

    public static ScheduledFuture<?> scheduleSingleExecution(String threadName, Runnable runnable, long delay, TimeUnit timeUnit) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(ThreadTools.createNamedThreadFactory(threadName));
        return executor.schedule(runnable, delay, timeUnit);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelayAndIterationLimit(String threadName, Runnable runnable, double initialDelay, double delay, int iterations) {
        long initialDelayNanos = Conversions.secondsToNanoseconds(initialDelay);
        long delayNanos = Conversions.secondsToNanoseconds(delay);
        return ThreadTools.scheduleWithFixedDelayAndIterationLimit(threadName, runnable, initialDelayNanos, delayNanos, TimeUnit.NANOSECONDS, iterations);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelayAndIterationLimit(String threadName, Runnable runnable, long initialDelay, long delay, TimeUnit timeUnit, int iterations) {
        AtomicInteger counter = new AtomicInteger(0);
        AtomicReference handleHolder = new AtomicReference();
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(ThreadTools.createNamedThreadFactory(threadName));
        handleHolder.set(scheduler.scheduleWithFixedDelay(() -> {
            ScheduledFuture scheduledFuture;
            if (counter.get() < iterations) {
                runnable.run();
            }
            counter.incrementAndGet();
            if (counter.get() >= iterations && (scheduledFuture = (ScheduledFuture)handleHolder.get()) != null) {
                scheduledFuture.cancel(true);
            }
        }, initialDelay, delay, timeUnit));
        return (ScheduledFuture)handleHolder.get();
    }
}

