/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import us.ihmc.commons.lists.SupplierBuilder;

public class BoundedRecyclingArrayList<T>
implements List<T> {
    private T[] values;
    private int size = 0;
    private final int maxCapacity;
    private final int minimumPositiveCapacity;
    private final Supplier<T> allocator;

    @Deprecated
    public BoundedRecyclingArrayList() {
        this(0, 0, (Supplier)null);
    }

    public BoundedRecyclingArrayList(int maxCapacity, Class<T> clazz) {
        this(0, maxCapacity, SupplierBuilder.createFromEmptyConstructor(clazz));
    }

    public BoundedRecyclingArrayList(int maxCapacity, Supplier<T> allocator) {
        this(0, maxCapacity, allocator);
    }

    public BoundedRecyclingArrayList(int initialCapacity, int maxCapacity, Class<T> clazz) {
        this(initialCapacity, maxCapacity, SupplierBuilder.createFromEmptyConstructor(clazz));
    }

    public BoundedRecyclingArrayList(int initialCapacity, int maxCapacity, Supplier<T> allocator) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal capacity: " + initialCapacity);
        }
        this.maxCapacity = maxCapacity;
        this.minimumPositiveCapacity = Math.min(8, maxCapacity);
        this.values = new Object[initialCapacity];
        this.allocator = allocator;
        this.fillElementDataIfNeeded();
    }

    public void shuffle(Random random) {
        for (int i = this.size; i > 1; --i) {
            this.unsafeSwap(i - 1, random.nextInt(i));
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.values.length;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public T add() {
        return this.getAndGrowIfNeeded(this.size);
    }

    public T insertAtIndex(int index) {
        this.rangeCheckForInsert(index);
        T ret = this.add();
        for (int i = this.size - 1; i > index; --i) {
            this.unsafeFastSwap(i, i - 1);
        }
        return ret;
    }

    @Override
    public T get(int i) {
        this.rangeCheck(i);
        return this.unsafeGet(i);
    }

    @Override
    public T getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.unsafeGet(0);
    }

    @Override
    public T getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.unsafeGet(this.size - 1);
    }

    protected T unsafeGet(int i) {
        return this.values[i];
    }

    public T getAndGrowIfNeeded(int index) {
        this.positiveIndexCheck(index);
        this.size = Math.max(this.size, index + 1);
        if (index >= this.values.length) {
            this.ensureCapacity(Math.max(this.minimumPositiveCapacity, this.size));
        }
        return this.values[index];
    }

    public void fastRemove(int index) {
        if (index == this.size - 1) {
            --this.size;
            return;
        }
        this.rangeCheck(index);
        this.unsafeFastSwap(index, --this.size);
    }

    public void swap(int i, int j) {
        this.rangeCheck(i);
        this.rangeCheck(j);
        this.unsafeSwap(i, j);
    }

    protected void unsafeSwap(int i, int j) {
        if (i == j) {
            return;
        }
        this.unsafeFastSwap(i, j);
    }

    private void unsafeFastSwap(int i, int j) {
        T t = this.values[i];
        this.values[i] = this.values[j];
        this.values[j] = t;
    }

    @Override
    public T remove(int i) {
        if (i == this.size - 1) {
            --this.size;
            return null;
        }
        this.rangeCheck(i);
        T t = this.values[i];
        while (i < this.size - 1) {
            this.values[i++] = this.values[i];
        }
        this.values[this.size - 1] = t;
        --this.size;
        return null;
    }

    @Override
    public boolean remove(Object object) {
        int index = this.indexOf(object);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        if (this.size() == 0) {
            return;
        }
        Arrays.sort(this.values, 0, this.size(), comparator);
    }

    protected void ensureCapacity(int minCapacity) {
        if (minCapacity <= this.values.length) {
            return;
        }
        if (minCapacity > this.maxCapacity) {
            throw new OutOfMemoryError("Requested capacity (" + minCapacity + ") is greater than max capacity (" + this.maxCapacity + ")!");
        }
        int previousArraySize = this.values.length;
        int newArraySize = previousArraySize + (previousArraySize >> 1);
        if (newArraySize - this.maxCapacity > 0) {
            newArraySize = this.maxCapacity;
        }
        if (newArraySize - minCapacity < 0) {
            newArraySize = minCapacity;
        }
        this.values = Arrays.copyOf(this.values, newArraySize);
        for (int i = previousArraySize; i < newArraySize; ++i) {
            this.values[i] = this.allocator.get();
        }
    }

    private void fillElementDataIfNeeded() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != null) continue;
            this.values[i] = this.allocator.get();
        }
    }

    protected void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.positiveIndexCheck(index);
    }

    protected void rangeCheckForInsert(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.positiveIndexCheck(index);
    }

    protected void positiveIndexCheck(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + index);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        if (object != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object != null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!object.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.values, this.size);
    }

    @Override
    public <X> X[] toArray(X[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.values, this.size, a.getClass());
        }
        System.arraycopy(this.values, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (this.size != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.values[i].equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty list";
        }
        Object ret = "";
        for (int i = 0; i < this.size - 1; ++i) {
            ret = (String)ret + this.unsafeGet(i).toString() + "\n";
        }
        ret = (String)ret + this.unsafeGet(this.size - 1).toString();
        return ret;
    }

    @Override
    public Iterator<T> iterator() {
        return new RecyclingArrayListIterator();
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private class RecyclingArrayListIterator
    implements Iterator<T> {
        int nextIndexToReturn = 0;
        boolean removeFlag = true;

        private RecyclingArrayListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.nextIndexToReturn <= BoundedRecyclingArrayList.this.size() - 1;
        }

        @Override
        public T next() {
            this.removeFlag = false;
            return BoundedRecyclingArrayList.this.get(this.nextIndexToReturn++);
        }

        @Override
        public void remove() {
            if (this.removeFlag) {
                throw new IllegalStateException();
            }
            BoundedRecyclingArrayList.this.remove(this.nextIndexToReturn - 1);
            --this.nextIndexToReturn;
            this.removeFlag = true;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            while (this.nextIndexToReturn < BoundedRecyclingArrayList.this.size()) {
                action.accept(BoundedRecyclingArrayList.this.values[this.nextIndexToReturn++]);
            }
        }
    }
}

