/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public class SupplierBuilder {
    public static <T> Supplier<T> createFromEmptyConstructor(Class<T> clazz) {
        Constructor emptyConstructor;
        try {
            emptyConstructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find a visible empty constructor in the class: " + clazz.getSimpleName());
        }
        return () -> {
            try {
                return emptyConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
                throw new RuntimeException("Something went wrong in the empty constructor implemented in the class: " + emptyConstructor.getDeclaringClass().getSimpleName());
            }
        };
    }

    public static <T> Supplier<T> indexedSupplier(IntFunction<T> indexBasedSupplier) {
        return SupplierBuilder.indexedSupplier(indexBasedSupplier, 0);
    }

    public static <T> Supplier<T> indexedSupplier(final IntFunction<T> indexBasedSupplier, final int startingIndex) {
        return new Supplier<T>(){
            int currentIndex;
            {
                this.currentIndex = startingIndex;
            }

            @Override
            public T get() {
                return indexBasedSupplier.apply(this.currentIndex++);
            }
        };
    }
}

