/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.maps;

import java.util.Arrays;

public class CircularLongMap {
    private int insertionIndex = 0;
    private int size = 0;
    private long lastInsertedKey = Long.MIN_VALUE;
    private final long[] keys;
    private final long[] values;

    public CircularLongMap(int elements) {
        this.keys = new long[elements];
        this.values = new long[elements];
    }

    public void insert(long key, long value) {
        if (key <= this.lastInsertedKey) {
            throw new IndexOutOfBoundsException("key is smaller than previously inserted key");
        }
        this.keys[this.insertionIndex] = key;
        this.values[this.insertionIndex] = value;
        this.lastInsertedKey = key;
        if (++this.insertionIndex >= this.keys.length) {
            this.insertionIndex = 0;
        }
        if (this.size < this.keys.length) {
            ++this.size;
        }
    }

    public int size() {
        return this.size;
    }

    public long getLatestKey() {
        if (this.insertionIndex == 0 && this.size > 0) {
            return this.keys[this.size - 1];
        }
        return this.keys[this.insertionIndex - 1];
    }

    public long getLatestValue() {
        if (this.insertionIndex == 0 && this.size > 0) {
            return this.values[this.size - 1];
        }
        return this.values[this.insertionIndex - 1];
    }

    public long getValue(boolean matchNearest, long key) {
        int index;
        if (this.insertionIndex == 0) {
            index = Arrays.binarySearch(this.keys, 0, this.size, key);
            if (matchNearest && index == -1) {
                index = 0;
            }
        } else if (this.size > this.insertionIndex && key < this.keys[0]) {
            index = Arrays.binarySearch(this.keys, this.insertionIndex, this.size, key);
            if (matchNearest && index == -this.insertionIndex - 1) {
                index = this.insertionIndex;
            }
        } else {
            index = Arrays.binarySearch(this.keys, 0, this.insertionIndex, key);
            if (matchNearest && index == -1) {
                index = 0;
            }
        }
        if (matchNearest) {
            return this.values[index < 0 ? -index - 2 : index];
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("No key with value " + key + " found");
        }
        return this.values[index];
    }

    public String toString() {
        return "index: " + this.insertionIndex + " keys: " + Arrays.toString(this.keys);
    }
}

