/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription;

import java.lang.reflect.Array;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.TexCoord2f;

public class MeshDataHolder
implements Transformable {
    private final Point3D32[] vertices;
    private final TexCoord2f[] texturePoints;
    private final int[] triangleIndices;
    private final Vector3D32[] vertexNormals;
    private String name = "MeshDataHolder";

    public MeshDataHolder(Point3D32[] vertices, TexCoord2f[] texturePoints, int[] triangleIndices, Vector3D32[] vertexNormals) {
        this.vertices = vertices;
        this.texturePoints = texturePoints;
        this.triangleIndices = triangleIndices;
        this.vertexNormals = vertexNormals;
    }

    public boolean containsNaN() {
        for (Point3D32 point3D32 : this.vertices) {
            if (!point3D32.containsNaN()) continue;
            return true;
        }
        for (TexCoord2f texCoord2f : this.texturePoints) {
            if (!texCoord2f.containsNaN()) continue;
            return true;
        }
        for (Vector3D32 vector3D32 : this.vertexNormals) {
            if (!vector3D32.containsNaN()) continue;
            return true;
        }
        return false;
    }

    public Point3D32[] getVertices() {
        return this.vertices;
    }

    public TexCoord2f[] getTexturePoints() {
        return this.texturePoints;
    }

    public int[] getTriangleIndices() {
        return this.triangleIndices;
    }

    public Vector3D32[] getVertexNormals() {
        return this.vertexNormals;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void applyTransform(Transform transform) {
        int i;
        for (i = 0; i < this.vertices.length; ++i) {
            this.vertices[i].applyTransform(transform);
        }
        for (i = 0; i < this.vertexNormals.length; ++i) {
            this.vertexNormals[i].applyTransform(transform);
        }
    }

    public void applyInverseTransform(Transform transform) {
        int i;
        for (i = 0; i < this.vertices.length; ++i) {
            this.vertices[i].applyInverseTransform(transform);
        }
        for (i = 0; i < this.vertexNormals.length; ++i) {
            this.vertexNormals[i].applyInverseTransform(transform);
        }
    }

    public static MeshDataHolder rotate(MeshDataHolder input, Orientation3DReadOnly rotation) {
        TexCoord2f[] texturePoints = input.getTexturePoints();
        int[] triangleIndices = input.getTriangleIndices();
        Point3D32[] inputVertices = input.getVertices();
        Vector3D32[] inputNormals = input.getVertexNormals();
        Point3D32[] outputVertices = new Point3D32[inputVertices.length];
        Vector3D32[] outputNormals = new Vector3D32[inputNormals.length];
        for (int i = 0; i < inputVertices.length; ++i) {
            outputVertices[i] = new Point3D32();
            outputNormals[i] = new Vector3D32();
            rotation.transform((Tuple3DReadOnly)inputVertices[i], (Tuple3DBasics)outputVertices[i]);
            rotation.transform((Tuple3DReadOnly)inputNormals[i], (Tuple3DBasics)outputNormals[i]);
        }
        return new MeshDataHolder(outputVertices, texturePoints, triangleIndices, outputNormals);
    }

    public static MeshDataHolder translate(MeshDataHolder input, float offsetX, float offsetY, float offsetZ) {
        Point3D32[] inputVertices = input.getVertices();
        TexCoord2f[] texturePoints = input.getTexturePoints();
        int[] triangleIndices = input.getTriangleIndices();
        Vector3D32[] normals = input.getVertexNormals();
        Point3D32[] outputVertices = new Point3D32[inputVertices.length];
        for (int i = 0; i < inputVertices.length; ++i) {
            outputVertices[i] = new Point3D32(offsetX, offsetY, offsetZ);
            outputVertices[i].add((Tuple3DReadOnly)inputVertices[i]);
        }
        return new MeshDataHolder(outputVertices, texturePoints, triangleIndices, normals);
    }

    public static MeshDataHolder translate(MeshDataHolder input, Tuple3DReadOnly offset) {
        return MeshDataHolder.translate(input, offset.getX32(), offset.getY32(), offset.getZ32());
    }

    public static MeshDataHolder combine(MeshDataHolder meshData1, MeshDataHolder meshData2, boolean updateMeshData2TrianglesIndices) {
        Point3D32[] vertices = MeshDataHolder.combineArrays(meshData1.vertices, meshData2.vertices);
        TexCoord2f[] texturePoints = MeshDataHolder.combineArrays(meshData1.texturePoints, meshData2.texturePoints);
        Vector3D32[] vertexNormals = MeshDataHolder.combineArrays(meshData1.vertexNormals, meshData2.vertexNormals);
        int[] triangleIndices = MeshDataHolder.combineArrays(meshData1.triangleIndices, meshData2.triangleIndices);
        if (updateMeshData2TrianglesIndices) {
            int shift = meshData1.vertices.length;
            int i = meshData1.triangleIndices.length;
            while (i < triangleIndices.length) {
                int n = i++;
                triangleIndices[n] = triangleIndices[n] + shift;
            }
        }
        return new MeshDataHolder(vertices, texturePoints, triangleIndices, vertexNormals);
    }

    private static <T> T[] combineArrays(T[] array1, T[] array2) {
        Object[] combined = (Object[])Array.newInstance(array1[0].getClass(), array1.length + array2.length);
        System.arraycopy(array1, 0, combined, 0, array1.length);
        System.arraycopy(array2, 0, combined, array1.length, array2.length);
        return combined;
    }

    private static int[] combineArrays(int[] array1, int[] array2) {
        int[] combined = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, combined, 0, array1.length);
        System.arraycopy(array2, 0, combined, array1.length, array2.length);
        return combined;
    }
}

