/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddExtrusionInstruction;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicAbstractShape;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoGraphicText3D
extends YoGraphicAbstractShape {
    private final Graphics3DObject graphics3dObject;
    private final Graphics3DAddExtrusionInstruction instruction;
    private final String text;
    private final AppearanceDefinition appearance;

    public YoGraphicText3D(String name, String text, YoFramePoint3D framePoint, YoFrameYawPitchRoll orientation, double scale, AppearanceDefinition appearance) {
        super(name, framePoint, orientation, scale);
        this.text = text;
        this.appearance = appearance;
        this.graphics3dObject = new Graphics3DObject();
        this.graphics3dObject.setChangeable(true);
        this.instruction = this.graphics3dObject.addText(text, 20.0, appearance);
    }

    public YoGraphicText3D(String name, String text, String namePrefix, String nameSuffix, YoRegistry registry, double scale, AppearanceDefinition appearance) {
        this(name, text, new YoFramePoint3D(namePrefix, nameSuffix, ReferenceFrame.getWorldFrame(), registry), new YoFrameYawPitchRoll(namePrefix, nameSuffix, ReferenceFrame.getWorldFrame(), registry), scale, appearance);
    }

    public void setAppearance(AppearanceDefinition appearance) {
        this.instruction.setAppearance(appearance);
    }

    public void setText(String text) {
        this.instruction.setText(text);
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.graphics3dObject;
    }

    @Override
    public YoGraphic duplicate(YoRegistry newRegistry) {
        return new YoGraphicText3D(this.getName(), this.text, this.yoFramePoint.duplicate(newRegistry), this.yoFrameYawPitchRoll.duplicate(newRegistry), this.scale, this.appearance);
    }
}

