/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics.plotting;

import java.awt.Color;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifact;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoArtifactOval
extends YoArtifact {
    private static final int LEGEND_DIAMETER = 10;
    private final YoFramePoint2D center;
    private final YoFrameVector2D radii;
    private final Point2D tempCenter = new Point2D();
    private final Vector2D tempRadii = new Vector2D();

    public YoArtifactOval(String name, YoDouble centerX, YoDouble centerY, YoDouble radius, Color color) {
        this(name, centerX, centerY, radius, radius, color);
    }

    public YoArtifactOval(String name, YoFramePoint3D center, YoDouble radius, Color color) {
        this(name, center.getYoX(), center.getYoY(), radius, radius, color);
    }

    private YoArtifactOval(String name, YoDouble centerX, YoDouble centerY, YoDouble radiusX, YoDouble radiusY, Color color) {
        this(name, new YoFramePoint2D(centerX, centerY, ReferenceFrame.getWorldFrame()), new YoFrameVector2D(radiusX, radiusY, ReferenceFrame.getWorldFrame()), color);
    }

    public YoArtifactOval(String name, YoFramePoint2D center, YoFrameVector2D radii, Color color) {
        super(name, new double[0], color, new YoVariable[]{center.getYoX(), center.getYoY(), radii.getYoX(), radii.getYoY()});
        this.center = center;
        this.radii = radii;
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
        graphics.setColor(this.color);
        this.tempCenter.set(origin);
        this.tempRadii.set(5.0, 5.0);
        graphics.drawOval(graphics.getScreenFrame(), (Point2DReadOnly)this.tempCenter, (Vector2DReadOnly)this.tempRadii);
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        this.tempCenter.set((Tuple2DReadOnly)this.center);
        this.tempRadii.set((Tuple2DReadOnly)this.radii);
        graphics.setColor(this.color);
        graphics.drawOval((Point2DReadOnly)this.tempCenter, (Vector2DReadOnly)this.tempRadii);
    }

    @Override
    public void drawHistoryEntry(Graphics2DAdapter graphics, double[] entry) {
        this.tempCenter.set(entry[0], entry[1]);
        this.tempRadii.set(entry[2], entry[3]);
        graphics.setColor(this.color);
        graphics.drawOval((Point2DReadOnly)this.tempCenter, (Vector2DReadOnly)this.tempRadii);
    }

    @Override
    public YoArtifact duplicate(YoRegistry newRegistry) {
        return new YoArtifactOval(this.getName(), this.center.duplicate(newRegistry), this.radii.duplicate(newRegistry), this.color);
    }
}

