/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXExtensions.chart;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.FastAxisBase;
import javafx.scene.shape.Rectangle;
import us.ihmc.javaFXExtensions.chart.DynamicChart;

public abstract class DynamicXYChart
extends DynamicChart {
    protected final ObjectProperty<FastAxisBase> xAxis = new SimpleObjectProperty((Object)this, "xAxis", null);
    protected final ObjectProperty<FastAxisBase> yAxis = new SimpleObjectProperty((Object)this, "xAxis", null);
    protected final Group plotContent = new Group(){

        public void requestLayout() {
        }
    };
    private final Rectangle plotContentClip = new Rectangle();

    public DynamicXYChart(FastAxisBase xAxis, FastAxisBase yAxis) {
        this.xAxis.set((Object)xAxis);
        this.yAxis.set((Object)yAxis);
        this.getChartChildren().addAll((Object[])new Node[]{this.plotContent, xAxis.asRegion(), yAxis.asRegion()});
        this.plotContent.setAutoSizeChildren(false);
        this.plotContentClip.setSmooth(false);
        this.plotContent.setClip((Node)this.plotContentClip);
        this.plotContent.getStyleClass().setAll((Object[])new String[]{"plot-content"});
        this.plotContent.setManaged(false);
        ChangeListener axisChangeListener = (o, oldValue, newValue) -> {
            int index = this.getChartChildren().indexOf((Object)oldValue.asRegion());
            this.getChartChildren().set(index, (Object)newValue.asRegion());
        };
        this.xAxis.addListener(axisChangeListener);
        this.yAxis.addListener(axisChangeListener);
    }

    @Override
    protected void layoutChartChildren(double top, double left, double width, double height) {
        double newXAxisHeight;
        this.updateAxisRange();
        top = this.snapPositionY(top);
        left = this.snapPositionX(left);
        FastAxisBase xAxis = (FastAxisBase)this.xAxisProperty().get();
        FastAxisBase yAxis = (FastAxisBase)this.yAxisProperty().get();
        double xAxisWidth = 0.0;
        double xAxisHeight = 0.0;
        double yAxisWidth = 0.0;
        double yAxisHeight = 0.0;
        for (int count = 0; count < 5 && (newXAxisHeight = xAxis.prefHeight(xAxisWidth = Math.max(0.0, this.snapSizeX(width - (yAxisWidth = yAxis.prefWidth(yAxisHeight = Math.max(0.0, this.snapSizeY(height - xAxisHeight)))))))) != xAxisHeight; ++count) {
            xAxisHeight = newXAxisHeight;
        }
        xAxisWidth = Math.ceil(xAxisWidth);
        xAxisHeight = Math.ceil(xAxisHeight);
        yAxisWidth = Math.ceil(yAxisWidth);
        yAxisHeight = Math.ceil(yAxisHeight);
        xAxis.resizeRelocate(left + yAxisWidth, top + yAxisHeight, xAxisWidth, xAxisHeight);
        yAxis.resizeRelocate(left + 1.0, top, yAxisWidth, yAxisHeight);
        xAxis.requestAxisLayout();
        xAxis.layout();
        yAxis.requestAxisLayout();
        yAxis.layout();
        this.layoutPlotChildren(top, left, xAxisWidth, yAxisHeight);
        this.plotContentClip.setX(left);
        this.plotContentClip.setY(top);
        this.plotContentClip.setWidth(xAxisWidth + 1.0);
        this.plotContentClip.setHeight(yAxisHeight + 1.0);
        this.plotContent.setLayoutX(left + yAxisWidth);
        this.plotContent.setLayoutY(top);
        this.plotContent.requestLayout();
    }

    protected abstract void layoutPlotChildren(double var1, double var3, double var5, double var7);

    protected abstract void updateAxisRange();

    public ObjectProperty<FastAxisBase> xAxisProperty() {
        return this.xAxis;
    }

    public void setXAxis(FastAxisBase xAxis) {
        this.xAxis.set((Object)xAxis);
    }

    public FastAxisBase getXAxis() {
        return (FastAxisBase)this.xAxis.get();
    }

    public ObjectProperty<FastAxisBase> yAxisProperty() {
        return this.yAxis;
    }

    public void setYAxis(FastAxisBase yAxis) {
        this.yAxis.set((Object)yAxis);
    }

    public FastAxisBase getYAxis() {
        return (FastAxisBase)this.yAxis.get();
    }
}

