/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.messager.javafx;

import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.TopicListener;
import us.ihmc.messager.TopicListenerBase;
import us.ihmc.messager.javafx.MessageBidirectionalBinding;

public interface JavaFXMessager
extends Messager {
    default public <T> Property<T> createPropertyInput(MessagerAPIFactory.Topic<T> topic) {
        return this.createPropertyInput(topic, null);
    }

    default public <T> Property<T> createPropertyInput(MessagerAPIFactory.Topic<T> topic, T initialValue) {
        SimpleObjectProperty input = new SimpleObjectProperty((Object)this, topic.getName(), initialValue);
        this.bindPropertyToTopic(topic, (Property<T>)input);
        return input;
    }

    default public <T> InvalidationListener bindTopic(MessagerAPIFactory.Topic<T> topicToBind, ObservableValue<T> observableValue) {
        InvalidationListener listener = observable -> this.submitMessage(topicToBind, observableValue.getValue());
        observableValue.addListener(listener);
        return listener;
    }

    default public <T> TopicListener<T> bindPropertyToTopic(MessagerAPIFactory.Topic<T> topic, Property<T> propertyToBind) {
        TopicListener listener = messageContent -> propertyToBind.setValue(messageContent);
        this.addFXTopicListener(topic, listener);
        return listener;
    }

    default public <T> MessageBidirectionalBinding<T, T> bindBidirectional(MessagerAPIFactory.Topic<T> topic, Property<T> property, boolean pushValue) {
        MessageBidirectionalBinding<Object, Object> bind = MessageBidirectionalBinding.createSingleTypedBinding(messageContent -> this.submitMessage(topic, messageContent), property);
        property.addListener(bind);
        this.addFXTopicListener(topic, bind);
        if (pushValue) {
            this.submitMessage(topic, property.getValue());
        }
        return bind;
    }

    default public <M, P> MessageBidirectionalBinding<M, P> bindBidirectional(MessagerAPIFactory.Topic<M> topic, Property<P> property, MessageBidirectionalBinding.PropertyToMessageTypeConverter<M, P> converter, boolean pushValue) {
        MessageBidirectionalBinding<Object, P> bind = new MessageBidirectionalBinding<Object, P>(messageContent -> this.submitMessage(topic, messageContent), property, converter);
        property.addListener(bind);
        this.addFXTopicListener(topic, bind);
        if (pushValue) {
            this.submitMessage(topic, converter.convert(property.getValue()));
        }
        return bind;
    }

    default public <T> void addFXTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListener<T> listener) {
        this.addFXTopicListenerBase(topic, (TopicListenerBase<T>)listener);
    }

    public <T> void addFXTopicListenerBase(MessagerAPIFactory.Topic<T> var1, TopicListenerBase<T> var2);

    public <T> boolean removeFXTopicListener(MessagerAPIFactory.Topic<T> var1, TopicListenerBase<T> var2);
}

