/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.messager.javafx;

import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import us.ihmc.messager.TopicListener;

public class MessageBidirectionalBinding<M, P>
implements TopicListener<M>,
ChangeListener<P> {
    private final AtomicBoolean changedOnMessageReception = new AtomicBoolean(false);
    private final Property<P> boundProperty;
    private final MessagingAction<M> messagingAction;
    private final PropertyToMessageTypeConverter<M, P> converter;

    public static <T> MessageBidirectionalBinding<T, T> createSingleTypedBinding(MessagingAction<T> messagingAction, Property<T> property) {
        return new MessageBidirectionalBinding<T, T>(messagingAction, property, new DummyConverter());
    }

    public MessageBidirectionalBinding(MessagingAction<M> messagingAction, Property<P> property, PropertyToMessageTypeConverter<M, P> converter) {
        this.boundProperty = property;
        this.messagingAction = messagingAction;
        this.converter = converter;
    }

    public void changed(ObservableValue<? extends P> observable, P oldValue, P newValue) {
        if (this.changedOnMessageReception.getAndSet(false)) {
            return;
        }
        M convertedPropertyValue = this.converter.convert(newValue);
        this.messagingAction.doMessageAction(convertedPropertyValue);
    }

    public void receivedMessageForTopic(M messageContent) {
        P interpretedContent = this.converter.interpret(messageContent);
        boolean updateProperty = this.boundProperty.getValue() == null ? interpretedContent != null : !this.boundProperty.getValue().equals(interpretedContent);
        this.changedOnMessageReception.set(updateProperty);
        if (updateProperty) {
            this.boundProperty.setValue(interpretedContent);
        }
    }

    private static class DummyConverter<T>
    implements PropertyToMessageTypeConverter<T, T> {
        private DummyConverter() {
        }

        @Override
        public T convert(T propertyValue) {
            return propertyValue;
        }

        @Override
        public T interpret(T messageContent) {
            return messageContent;
        }
    }

    public static interface MessagingAction<T> {
        public void doMessageAction(T var1);
    }

    public static interface PropertyToMessageTypeConverter<M, P> {
        public M convert(P var1);

        public P interpret(M var1);
    }
}

