/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.messager.javafx;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.messager.Message;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.SharedMemoryMessager;
import us.ihmc.messager.SynchronizeHint;
import us.ihmc.messager.TopicListenerBase;
import us.ihmc.messager.javafx.JavaFXMessager;

public class SharedMemoryJavaFXMessager
extends SharedMemoryMessager
implements JavaFXMessager {
    private final Map<MessagerAPIFactory.Topic<?>, JavaFXTopicListeners> fxTopicListeners = new HashMap();
    private final AnimationTimer animationTimer;
    private boolean readingListeners = false;

    public SharedMemoryJavaFXMessager(MessagerAPIFactory.MessagerAPI messagerAPI) {
        this(messagerAPI, false);
    }

    public SharedMemoryJavaFXMessager(MessagerAPIFactory.MessagerAPI messagerAPI, boolean managed) {
        super(messagerAPI);
        this.animationTimer = managed ? null : new AnimationTimer(){

            public void handle(long now) {
                SharedMemoryJavaFXMessager.this.updateFXTopicListeners();
            }
        };
    }

    public void updateFXTopicListeners() {
        try {
            this.readingListeners = true;
            this.fxTopicListeners.entrySet().removeIf(entry -> ((JavaFXTopicListeners)entry.getValue()).isEmpty());
            for (JavaFXTopicListeners listener : this.fxTopicListeners.values()) {
                listener.notifyListeners();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.readingListeners = false;
        }
    }

    public <T> void submitMessage(Message<T> message) {
        super.submitMessage(message);
        JavaFXTopicListeners topicListeners = this.fxTopicListeners.get(message.getTopic(this.messagerAPI));
        if (topicListeners != null) {
            topicListeners.submitMessage(message);
        }
    }

    @Override
    public <T> void addFXTopicListenerBase(MessagerAPIFactory.Topic<T> topic, TopicListenerBase<T> listener) {
        JavaFXTopicListeners topicListeners = this.fxTopicListeners.get(topic);
        if (topicListeners != null) {
            topicListeners.addListener(listener);
            return;
        }
        if (!this.readingListeners && Platform.isFxApplicationThread()) {
            topicListeners = new JavaFXTopicListeners(topic);
            this.fxTopicListeners.put(topic, topicListeners);
            topicListeners.addListener(listener);
        } else {
            try {
                this.runFXLater(() -> this.addFXTopicListenerBase(topic, listener));
                return;
            }
            catch (IllegalStateException e) {
                topicListeners = new JavaFXTopicListeners(topic);
                this.fxTopicListeners.put(topic, topicListeners);
                topicListeners.addListener(listener);
            }
        }
    }

    protected void runFXLater(Runnable fxTask) {
        Platform.runLater((Runnable)fxTask);
    }

    protected void runFXAndWait(Runnable fxTask) {
        if (Platform.isFxApplicationThread()) {
            this.tryRun(fxTask);
        } else {
            CountDownLatch doneLatch = new CountDownLatch(1);
            this.runFXLater(() -> {
                this.tryRun(fxTask);
                doneLatch.countDown();
            });
            try {
                doneLatch.await();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void tryRun(Runnable fxTask) {
        try {
            fxTask.run();
        }
        catch (Throwable t) {
            System.err.println("Exception in fxTask");
            t.printStackTrace();
        }
    }

    @Override
    public <T> boolean removeFXTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListenerBase<T> listener) {
        JavaFXTopicListeners topicListeners = this.fxTopicListeners.get(topic);
        if (topicListeners == null) {
            return false;
        }
        if (!this.readingListeners && Platform.isFxApplicationThread()) {
            return topicListeners.removeListener(listener);
        }
        try {
            MutableBoolean result = new MutableBoolean();
            this.runFXAndWait(() -> result.setValue(topicListeners.removeListener(listener)));
            return result.booleanValue();
        }
        catch (IllegalStateException e) {
            return topicListeners.removeListener(listener);
        }
    }

    public void startMessager() {
        super.startMessager();
        if (this.animationTimer != null) {
            this.animationTimer.start();
        }
    }

    public void closeMessager() {
        this.fxTopicListeners.values().forEach(JavaFXTopicListeners::dispose);
        this.fxTopicListeners.clear();
        super.closeMessager();
        if (this.animationTimer != null) {
            this.animationTimer.stop();
        }
    }

    protected class JavaFXTopicListeners {
        protected final ConcurrentLinkedQueue<Message<Object>> messageQueue = new ConcurrentLinkedQueue();
        protected final ConcurrentLinkedQueue<TopicListenerBase<Object>> listeners = new ConcurrentLinkedQueue();

        protected JavaFXTopicListeners(MessagerAPIFactory.Topic<?> topic) {
        }

        protected void submitMessage(Message<Object> message) {
            if (message.getSynchronizeHint() == SynchronizeHint.SYNCHRONOUS) {
                SharedMemoryJavaFXMessager.this.runFXAndWait(() -> this.listeners.forEach((Consumer<TopicListenerBase<Object>>)((Consumer<TopicListenerBase>)listener -> listener.receivedMessageForTopic(message))));
            } else {
                this.messageQueue.add(message);
            }
        }

        protected void addListener(TopicListenerBase<?> listener) {
            this.listeners.add(listener);
        }

        protected boolean removeListener(TopicListenerBase<?> listener) {
            return this.listeners.remove(listener);
        }

        protected void notifyListeners() {
            while (!this.messageQueue.isEmpty()) {
                Message<Object> newMessage = this.messageQueue.poll();
                this.listeners.forEach((Consumer<TopicListenerBase<Object>>)((Consumer<TopicListenerBase>)listener -> listener.receivedMessageForTopic(newMessage)));
            }
        }

        protected boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        protected void dispose() {
            this.messageQueue.clear();
            this.listeners.clear();
        }
    }
}

