/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.messager;

import java.util.Objects;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.SynchronizeHint;

public final class Message<T> {
    public MessagerAPIFactory.TopicID topicID;
    public T messageContent;
    public SynchronizeHint synchronizeHint;

    public Message() {
    }

    public Message(MessagerAPIFactory.Topic<T> topic, T messageContent) {
        this.topicID = topic.getUniqueID();
        this.messageContent = messageContent;
    }

    public Message(MessagerAPIFactory.TopicID topicID, T messageContent) {
        this.topicID = topicID;
        this.messageContent = messageContent;
    }

    public Message(Message<T> other) {
        this.set(other);
    }

    public void set(Message<T> other) {
        this.topicID = other.topicID;
        this.messageContent = other.messageContent;
        this.synchronizeHint = other.synchronizeHint;
    }

    public MessagerAPIFactory.TopicID getTopicID() {
        return this.topicID;
    }

    public MessagerAPIFactory.Topic<T> getTopic(MessagerAPIFactory.MessagerAPI api) {
        return api.findTopic(this.topicID);
    }

    public T getMessageContent() {
        return this.messageContent;
    }

    public void setSynchronizeHint(SynchronizeHint synchronizeHint) {
        this.synchronizeHint = synchronizeHint;
    }

    public SynchronizeHint getSynchronizeHint() {
        return this.synchronizeHint;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Message) {
            Message other = (Message)object;
            if (!Objects.equals(this.topicID, other.topicID)) {
                return false;
            }
            if (!Objects.equals(this.messageContent, other.messageContent)) {
                return false;
            }
            return Objects.equals((Object)this.synchronizeHint, (Object)other.synchronizeHint);
        }
        return false;
    }
}

