/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.messager;

import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.messager.Message;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.MessagerStateListener;
import us.ihmc.messager.SynchronizeHint;
import us.ihmc.messager.TopicListener;
import us.ihmc.messager.TopicListenerBase;

public interface Messager {
    default public <T> void submitMessage(MessagerAPIFactory.Topic<T> topic, T messageContent) {
        this.submitMessage(topic, messageContent, SynchronizeHint.NONE);
    }

    default public <T> void submitMessage(MessagerAPIFactory.Topic<T> topic, T messageContent, SynchronizeHint hint) {
        Message<T> message = new Message<T>(topic, messageContent);
        message.setSynchronizeHint(hint);
        this.submitMessage(message);
    }

    public <T> void submitMessage(Message<T> var1);

    public <T> AtomicReference<T> createInput(MessagerAPIFactory.Topic<T> var1, T var2);

    public <T> void attachInput(MessagerAPIFactory.Topic<T> var1, AtomicReference<T> var2);

    default public <T> AtomicReference<T> createInput(MessagerAPIFactory.Topic<T> topic) {
        return this.createInput(topic, null);
    }

    public <T> boolean removeInput(MessagerAPIFactory.Topic<T> var1, AtomicReference<T> var2);

    public <T> void addTopicListenerBase(MessagerAPIFactory.Topic<T> var1, TopicListenerBase<T> var2);

    default public <T> void addTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListener<T> listener) {
        this.addTopicListenerBase(topic, listener);
    }

    public <T> boolean removeTopicListener(MessagerAPIFactory.Topic<T> var1, TopicListenerBase<T> var2);

    public void startMessager() throws Exception;

    public void closeMessager() throws Exception;

    public boolean isMessagerOpen();

    public void notifyMessagerStateListeners();

    public void addMessagerStateListener(MessagerStateListener var1);

    public boolean removeMessagerStateListener(MessagerStateListener var1);

    public MessagerAPIFactory.MessagerAPI getMessagerAPI();
}

