/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.messager;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessagerAPIFactory {
    private boolean isFactoryClosed = false;
    private Map<Integer, CategoryTheme> categoryThemeIDSet = new HashMap<Integer, CategoryTheme>();
    private Map<Integer, TopicTheme> topicThemeIDSet = new HashMap<Integer, TopicTheme>();
    private MessagerAPI api;

    public Category createRootCategory(String rootCategoryName) {
        return this.createRootCategory(this.createCategoryTheme(rootCategoryName));
    }

    public Category createRootCategory(CategoryTheme rootTheme) {
        this.assertFactoryIsOpen();
        Category root = new Category(null, rootTheme);
        this.api = new MessagerAPI(root);
        return root;
    }

    public void includeMessagerAPIs(MessagerAPI ... apis) {
        if (this.api == null) {
            throw new RuntimeException("Call MessageAPIFactory.createRootCategory(...) before calling this method.");
        }
        for (MessagerAPI messagerAPI : apis) {
            for (Category root : messagerAPI.roots) {
                this.api.addRoot(root);
            }
        }
    }

    public MessagerAPI getAPIAndCloseFactory() {
        this.isFactoryClosed = true;
        this.categoryThemeIDSet = null;
        this.topicThemeIDSet = null;
        return this.api;
    }

    public CategoryTheme createCategoryTheme(String name) {
        this.assertFactoryIsOpen();
        CategoryTheme newTheme = new CategoryTheme(name);
        if (this.categoryThemeIDSet.put(newTheme.getID(), newTheme) != null) {
            throw new RuntimeException("Duplicate category theme id.");
        }
        return newTheme;
    }

    public TopicTheme createTopicTheme(String name) {
        this.assertFactoryIsOpen();
        TopicTheme newTheme = new TopicTheme(name);
        TopicTheme oldTheme = this.topicThemeIDSet.put(newTheme.getID(), newTheme);
        if (oldTheme != null && !oldTheme.equals(newTheme)) {
            throw new RuntimeException("Duplicate topic theme id.");
        }
        return newTheme;
    }

    public <T> TypedTopicTheme<T> createTypedTopicTheme(String name) {
        TypedTopicTheme newTheme = new TypedTopicTheme(name);
        TopicTheme oldTheme = this.topicThemeIDSet.put(newTheme.getID(), newTheme);
        if (oldTheme != null && !oldTheme.equals(newTheme)) {
            throw new RuntimeException("Duplicate topic theme id.");
        }
        return newTheme;
    }

    private void assertFactoryIsOpen() {
        if (this.isFactoryClosed) {
            throw new RuntimeException("This API factory is closed, the API cannot be changed.");
        }
    }

    public class CategoryTheme {
        private final int id;
        private final String name;

        private CategoryTheme(String name) {
            this.name = name;
            this.id = name.hashCode();
            MessagerAPIFactory.this.assertFactoryIsOpen();
        }

        private int getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CategoryTheme) {
                return this.equals((CategoryTheme)obj);
            }
            return false;
        }

        public boolean equals(CategoryTheme other) {
            return this.id == other.id && other.name.equals(other.name);
        }

        public String toString() {
            return this.getName() + ", id = " + this.id;
        }
    }

    public class Category {
        private final Category parent;
        private final CategoryTheme theme;
        private final TIntObjectMap<Category> childrenCategories = new TIntObjectHashMap();
        private final TIntObjectMap<Topic<?>> childrenTopics = new TIntObjectHashMap();

        private Category(Category parentCategory, CategoryTheme categoryTheme) {
            this.parent = parentCategory;
            this.theme = categoryTheme;
            MessagerAPIFactory.this.assertFactoryIsOpen();
        }

        public Category child(CategoryTheme subCategoryTheme) {
            MessagerAPIFactory.this.assertFactoryIsOpen();
            Category childCategory = (Category)this.childrenCategories.get(subCategoryTheme.getID());
            if (childCategory == null) {
                Category newChild = new Category(this, subCategoryTheme);
                this.childrenCategories.put(subCategoryTheme.getID(), (Object)newChild);
                return newChild;
            }
            if (childCategory.theme.equals(subCategoryTheme)) {
                return childCategory;
            }
            throw new RuntimeException("Not expecting a CategoryTheme with same id as one of this children but different name.");
        }

        public <T> Topic<T> topic(TypedTopicTheme<T> topicTheme) {
            return this.topic((TopicTheme)topicTheme);
        }

        public <T> Topic<T> topic(TopicTheme topicTheme) {
            MessagerAPIFactory.this.assertFactoryIsOpen();
            Topic childTopic = (Topic)this.childrenTopics.get(topicTheme.getID());
            if (childTopic == null) {
                Topic newChild = new Topic(this, topicTheme);
                this.childrenTopics.put(topicTheme.getID(), newChild);
                return newChild;
            }
            if (childTopic.theme.equals(topicTheme)) {
                return childTopic;
            }
            throw new RuntimeException("Not expecting a TopicTheme with same id as one of this children but different name.");
        }

        public Category[] getChildrenCategories() {
            return (Category[])this.childrenCategories.values((Object[])new Category[this.childrenCategories.size()]);
        }

        public Topic<?>[] getChildrenTopics() {
            return (Topic[])this.childrenTopics.values((Object[])new Topic[this.childrenTopics.size()]);
        }

        public List<Topic<?>> getAllTopics() {
            ArrayList topics = new ArrayList();
            topics.addAll(this.childrenTopics.valueCollection());
            for (Category childCategory : this.childrenCategories.valueCollection()) {
                topics.addAll(childCategory.getAllTopics());
            }
            return topics;
        }

        public <T> Topic<T> findTopic(TopicID topicID) {
            int childrenDepth = this.getDepth() + 1;
            int shortIDAtDepth = topicID.getShortIDAtDepth(childrenDepth);
            if (childrenDepth == topicID.getTopicDepth()) {
                return (Topic)this.childrenTopics.get(shortIDAtDepth);
            }
            if (this.childrenCategories.containsKey(shortIDAtDepth)) {
                Category child = (Category)this.childrenCategories.get(shortIDAtDepth);
                return child.findTopic(topicID);
            }
            return null;
        }

        private int getDepth() {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getDepth() + 1;
        }

        private void fillChildUniqueID(int[] topicUniqueIDToFill) {
            topicUniqueIDToFill[this.getDepth()] = this.theme.getID();
            if (this.parent != null) {
                this.parent.fillChildUniqueID(topicUniqueIDToFill);
            }
        }

        private int getShortID() {
            return this.theme.getID();
        }

        private TopicID getUniqueID() {
            int idLength = this.getDepth() + 1;
            int[] uniqueID = new int[idLength];
            uniqueID[idLength - 1] = this.theme.getID();
            if (this.parent != null) {
                this.parent.fillChildUniqueID(uniqueID);
            }
            return new TopicID(uniqueID);
        }

        public String getName() {
            if (this.parent == null) {
                return this.getSimpleName();
            }
            return this.parent.getName() + "/" + this.getSimpleName();
        }

        public String getSimpleName() {
            return this.theme.getName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Category) {
                return this.equals((Category)obj);
            }
            return false;
        }

        public boolean equals(Category other) {
            if (!this.theme.equals(other.theme)) {
                return false;
            }
            return this.parent == null ? other.parent == null : this.parent.equals(other.parent);
        }

        public String toString() {
            return this.getName() + ", id = " + this.getUniqueID();
        }
    }

    public static class MessagerAPI {
        private final List<Category> roots = new ArrayList<Category>();

        private MessagerAPI(Category root) {
            this.roots.add(root);
        }

        private void addRoot(Category newRoot) {
            for (Category root : this.roots) {
                if (!root.getName().equals(newRoot.getName()) && root.getShortID() != newRoot.getShortID()) continue;
                throw new RuntimeException("Roots must have unique name and ID.");
            }
            this.roots.add(newRoot);
        }

        public <T> Topic<T> findTopic(TopicID topicID) {
            for (Category root : this.roots) {
                if (topicID.getShortIDAtDepth(0) != root.getShortID()) continue;
                return root.findTopic(topicID);
            }
            throw new RuntimeException("The topic id does not belong to this API.");
        }

        public <T> boolean containsTopic(Topic<T> topic) {
            return this.containsTopic(topic.getUniqueID());
        }

        public boolean containsTopic(TopicID topicID) {
            for (Category root : this.roots) {
                if (topicID.getShortIDAtDepth(0) != root.getShortID()) continue;
                return root.findTopic(topicID) != null;
            }
            return false;
        }

        public List<Topic<?>> getAllTopics() {
            ArrayList topics = new ArrayList();
            for (Category root : this.roots) {
                topics.addAll(root.getAllTopics());
            }
            return topics;
        }

        public String toString() {
            return "API of " + this.roots.get(0).getName();
        }
    }

    public class TopicTheme {
        private final int id;
        private final String name;

        private TopicTheme(String name) {
            this.name = name;
            this.id = name.hashCode();
            MessagerAPIFactory.this.assertFactoryIsOpen();
        }

        int getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TopicTheme) {
                return this.equals((TopicTheme)obj);
            }
            return false;
        }

        public boolean equals(TopicTheme other) {
            return this.id == other.id && other.name.equals(other.name);
        }

        public String toString() {
            return this.getName() + ", id = " + this.id;
        }
    }

    public class TypedTopicTheme<T>
    extends TopicTheme {
        private TypedTopicTheme(String name) {
            super(name);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TypedTopicTheme) {
                return super.equals((TopicTheme)obj);
            }
            return false;
        }
    }

    public static class TopicID {
        public int[] id;

        public TopicID() {
        }

        public TopicID(int[] id) {
            this.id = id;
        }

        private int getTopicDepth() {
            return this.id.length - 1;
        }

        private int getShortIDAtDepth(int depth) {
            return this.id[depth];
        }

        public boolean equals(Object obj) {
            if (obj instanceof TopicID) {
                return this.equals((TopicID)obj);
            }
            return false;
        }

        public boolean equals(TopicID other) {
            return Arrays.equals(this.id, other.id);
        }

        public String toString() {
            return Arrays.toString(this.id);
        }
    }

    public static class Topic<T> {
        private final TopicTheme theme;
        private final Category category;

        private Topic(Category topicCategory, TopicTheme topicTheme) {
            if (topicCategory == null) {
                throw new RuntimeException("A topic has to belong to a category.");
            }
            this.category = topicCategory;
            this.theme = topicTheme;
        }

        private int getDepth() {
            return this.category.getDepth() + 1;
        }

        public TopicID getUniqueID() {
            int idLength = this.getDepth() + 1;
            int[] uniqueID = new int[idLength];
            uniqueID[idLength - 1] = this.theme.getID();
            this.category.fillChildUniqueID(uniqueID);
            return new TopicID(uniqueID);
        }

        public String getName() {
            return this.category.getName() + "/" + this.getSimpleName();
        }

        public String getSimpleName() {
            return this.theme.getName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Topic) {
                return this.equals((Topic)obj);
            }
            return false;
        }

        public boolean equals(Topic<T> other) {
            if (!this.theme.equals(other.theme)) {
                return false;
            }
            return this.category.equals(other.category);
        }

        public String toString() {
            return this.getName() + ", id = " + this.getUniqueID();
        }
    }
}

