/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.messager;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Message;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.MessagerStateListener;
import us.ihmc.messager.SynchronizeHint;
import us.ihmc.messager.TopicListenerBase;

public class SharedMemoryMessager
implements Messager {
    protected final MessagerAPIFactory.MessagerAPI messagerAPI;
    protected final AtomicBoolean isConnected = new AtomicBoolean(false);
    protected final ConcurrentHashMap<MessagerAPIFactory.Topic<?>, TopicEntry> topicEntries = new ConcurrentHashMap();
    protected final List<MessagerStateListener> connectionStateListeners = new ArrayList<MessagerStateListener>();

    public SharedMemoryMessager(MessagerAPIFactory.MessagerAPI messagerAPI) {
        this.messagerAPI = messagerAPI;
    }

    @Override
    public <T> void submitMessage(Message<T> message) {
        if (!this.messagerAPI.containsTopic(message.getTopicID())) {
            throw new RuntimeException("The message is not part of this messager's API.");
        }
        MessagerAPIFactory.Topic messageTopic = this.messagerAPI.findTopic(message.getTopicID());
        if (!this.isConnected.get()) {
            LogTools.warn((String)("This messager is closed, message's topic: " + messageTopic.getSimpleName()));
            return;
        }
        TopicEntry topicEntry = this.topicEntries.get(messageTopic);
        if (topicEntry != null) {
            if (message.getSynchronizeHint() == null) {
                message.setSynchronizeHint(SynchronizeHint.NONE);
            }
            topicEntry.consumeMessage(message);
        }
    }

    @Override
    public <T> AtomicReference<T> createInput(MessagerAPIFactory.Topic<T> topic, T defaultValue) {
        AtomicReference<T> boundVariable = new AtomicReference<T>(defaultValue);
        this.attachInput(topic, boundVariable);
        return boundVariable;
    }

    @Override
    public <T> void attachInput(MessagerAPIFactory.Topic<T> topic, AtomicReference<T> input) {
        TopicEntry topicEntry = this.topicEntries.get(topic);
        if (topicEntry == null) {
            topicEntry = new TopicEntry();
            this.topicEntries.put(topic, topicEntry);
        }
        topicEntry.bindVariable(input);
    }

    @Override
    public <T> boolean removeInput(MessagerAPIFactory.Topic<T> topic, AtomicReference<T> input) {
        TopicEntry topicEntry = this.topicEntries.get(topic);
        if (topicEntry == null) {
            return false;
        }
        return topicEntry.removeVariable(input);
    }

    @Override
    public <T> void addTopicListenerBase(MessagerAPIFactory.Topic<T> topic, TopicListenerBase<T> listener) {
        TopicEntry topicEntry = this.topicEntries.get(topic);
        if (topicEntry == null) {
            topicEntry = new TopicEntry();
            this.topicEntries.put(topic, topicEntry);
        }
        topicEntry.addListener(listener);
    }

    @Override
    public <T> boolean removeTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListenerBase<T> listener) {
        TopicEntry topicEntry = this.topicEntries.get(topic);
        if (topicEntry == null) {
            return false;
        }
        return topicEntry.removeListener(listener);
    }

    @Override
    public void startMessager() {
        this.isConnected.set(true);
        this.notifyMessagerStateListeners();
    }

    @Override
    public void closeMessager() {
        this.isConnected.set(false);
        this.notifyMessagerStateListeners();
        this.topicEntries.values().forEach(TopicEntry::clear);
        this.topicEntries.clear();
        this.connectionStateListeners.clear();
    }

    @Override
    public boolean isMessagerOpen() {
        return this.isConnected.get();
    }

    @Override
    public void addMessagerStateListener(MessagerStateListener listener) {
        this.connectionStateListeners.add(listener);
    }

    @Override
    public boolean removeMessagerStateListener(MessagerStateListener listener) {
        return this.connectionStateListeners.remove(listener);
    }

    @Override
    public void notifyMessagerStateListeners() {
        this.connectionStateListeners.forEach(listener -> listener.messagerStateChanged(this.isMessagerOpen()));
    }

    @Override
    public MessagerAPIFactory.MessagerAPI getMessagerAPI() {
        return this.messagerAPI;
    }

    protected static class TopicEntry {
        private final Queue<AtomicReference<Object>> boundVariables = new ConcurrentLinkedQueue<AtomicReference<Object>>();
        private final Queue<TopicListenerBase<Object>> topicListeners = new ConcurrentLinkedQueue<TopicListenerBase<Object>>();

        protected TopicEntry() {
        }

        protected void clear() {
            this.boundVariables.clear();
            this.topicListeners.clear();
        }

        protected void bindVariable(AtomicReference<Object> variable) {
            this.boundVariables.add(variable);
        }

        protected boolean removeVariable(AtomicReference<Object> variable) {
            return this.boundVariables.remove(variable);
        }

        protected void addListener(TopicListenerBase<Object> listener) {
            this.topicListeners.add(listener);
        }

        protected boolean removeListener(TopicListenerBase<Object> listener) {
            return this.topicListeners.remove(listener);
        }

        protected void consumeMessage(Message<Object> message) {
            Object messageContent = message.getMessageContent();
            for (AtomicReference atomicReference : this.boundVariables) {
                atomicReference.set(messageContent);
            }
            for (TopicListenerBase topicListenerBase : this.topicListeners) {
                topicListenerBase.receivedMessageForTopic(message);
            }
        }
    }
}

