/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub;

import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessDomain;

public class DomainFactory {
    public static synchronized Domain getDefaultDomain() {
        return DomainFactory.getDomain(PubSubImplementation.FAST_RTPS);
    }

    public static synchronized Domain getDomain(PubSubImplementation impl) {
        switch (impl) {
            case FAST_RTPS: {
                return FastRTPSDomain.getInstance(false);
            }
            case FAST_RTPS_SYSTEM_LIBRARY: {
                return FastRTPSDomain.getInstance(true);
            }
            case INTRAPROCESS: {
                return IntraProcessDomain.getInstance();
            }
        }
        throw new RuntimeException("Invalid implementation specified");
    }

    public static enum PubSubImplementation {
        FAST_RTPS,
        FAST_RTPS_SYSTEM_LIBRARY,
        INTRAPROCESS;

    }
}

