/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rtps.impl.fastRTPS;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSJNI;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantImpl;
import us.ihmc.rtps.impl.fastRTPS.NativePublisherListener;
import us.ihmc.rtps.impl.fastRTPS.Time_t;

public class NativePublisherImpl {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected NativePublisherImpl(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(NativePublisherImpl obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(NativePublisherImpl obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                FastRTPSJNI.delete_NativePublisherImpl(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public NativePublisherImpl(NativeParticipantImpl participant, NativePublisherListener listener) throws IOException {
        this(FastRTPSJNI.new_NativePublisherImpl(NativeParticipantImpl.getCPtr(participant), participant, NativePublisherListener.getCPtr(listener), listener), true);
    }

    public boolean createPublisher() {
        return FastRTPSJNI.NativePublisherImpl_createPublisher__SWIG_0(this.swigCPtr, this);
    }

    public boolean createPublisher(String publisherProfile, String XMLConfigData, long XMLdataLength) {
        return FastRTPSJNI.NativePublisherImpl_createPublisher__SWIG_1(this.swigCPtr, this, publisherProfile, XMLConfigData, XMLdataLength);
    }

    public void write(ByteBuffer data, int dataLength, short encapsulation, ByteBuffer key, int keyLength) {
        assert (data.isDirect()) : "Buffer must be allocated direct.";
        assert (key.isDirect()) : "Buffer must be allocated direct.";
        FastRTPSJNI.NativePublisherImpl_write(this.swigCPtr, this, data, dataLength, encapsulation, key, keyLength);
    }

    public void dispose(ByteBuffer data, int dataLength, short encapsulation, ByteBuffer key, int keyLength) {
        assert (data.isDirect()) : "Buffer must be allocated direct.";
        assert (key.isDirect()) : "Buffer must be allocated direct.";
        FastRTPSJNI.NativePublisherImpl_dispose(this.swigCPtr, this, data, dataLength, encapsulation, key, keyLength);
    }

    public void unregister(ByteBuffer data, int dataLength, short encapsulation, ByteBuffer key, int keyLength) {
        assert (data.isDirect()) : "Buffer must be allocated direct.";
        assert (key.isDirect()) : "Buffer must be allocated direct.";
        FastRTPSJNI.NativePublisherImpl_unregister(this.swigCPtr, this, data, dataLength, encapsulation, key, keyLength);
    }

    public void dispose_and_unregister(ByteBuffer data, int dataLength, short encapsulation, ByteBuffer key, int keyLength) {
        assert (data.isDirect()) : "Buffer must be allocated direct.";
        assert (key.isDirect()) : "Buffer must be allocated direct.";
        FastRTPSJNI.NativePublisherImpl_dispose_and_unregister(this.swigCPtr, this, data, dataLength, encapsulation, key, keyLength);
    }

    public int removeAllChange() {
        return FastRTPSJNI.NativePublisherImpl_removeAllChange(this.swigCPtr, this);
    }

    public boolean wait_for_all_acked(Time_t max_wait) {
        return FastRTPSJNI.NativePublisherImpl_wait_for_all_acked(this.swigCPtr, this, Time_t.getCPtr(max_wait), max_wait);
    }

    public long getGuidLow() {
        return FastRTPSJNI.NativePublisherImpl_getGuidLow(this.swigCPtr, this);
    }

    public long getGuidHigh() {
        return FastRTPSJNI.NativePublisherImpl_getGuidHigh(this.swigCPtr, this);
    }
}

