/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.PawCliffDetectionTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class PawCliffDetectionToolsTest {
    @Test
    public void testFindHighestNearbyPoint2() {
        ConvexPolygon2D groundRegion = new ConvexPolygon2D();
        groundRegion.addVertex(5.0, 5.0);
        groundRegion.addVertex(5.0, -5.0);
        groundRegion.addVertex(-5.0, 5.0);
        groundRegion.addVertex(-5.0, -5.0);
        groundRegion.update();
        ConvexPolygon2D cliffRegion = new ConvexPolygon2D();
        cliffRegion.addVertex(0.2, 0.2);
        cliffRegion.addVertex(0.2, -0.2);
        cliffRegion.addVertex(-0.2, 0.2);
        cliffRegion.addVertex(-0.2, -0.2);
        cliffRegion.update();
        RigidBodyTransform higherCliff = new RigidBodyTransform();
        RigidBodyTransform lowerCliff = new RigidBodyTransform();
        higherCliff.getTranslation().set(0.5, 0.0, 0.3);
        lowerCliff.getTranslation().set(0.5, 0.0, 0.05);
        PlanarRegion ground = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), (Vertex2DSupplier)groundRegion);
        PlanarRegion higherCliffRegion = new PlanarRegion((RigidBodyTransformReadOnly)higherCliff, (Vertex2DSupplier)cliffRegion);
        PlanarRegion lowerCliffRegion = new PlanarRegion((RigidBodyTransformReadOnly)lowerCliff, (Vertex2DSupplier)cliffRegion);
        ArrayList<PlanarRegion> regions = new ArrayList<PlanarRegion>();
        regions.add(ground);
        regions.add(higherCliffRegion);
        regions.add(lowerCliffRegion);
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(regions);
        double heightToAvoid = 0.25;
        Assert.assertEquals((double)PawCliffDetectionTools.findHighestNearbyPoint((PlanarRegionsList)planarRegionsList, (Point3DReadOnly)new Point3D(0.25, 0.0, 0.0), (double)0.0, (Point3DBasics)new Point3D(), (double)0.2, (double)-0.1, (double)0.1, (double)-0.1), (double)0.3, (double)1.0E-5);
        Assert.assertTrue((boolean)PawCliffDetectionTools.isNearCliff((PlanarRegionsList)planarRegionsList, (Point3DReadOnly)new Point3D(0.25, 0.0, 0.0), (double)0.0, (double)heightToAvoid, (double)0.2, (double)-0.1, (double)0.1, (double)-0.1));
        heightToAvoid = 0.34;
        Assert.assertFalse((boolean)PawCliffDetectionTools.isNearCliff((PlanarRegionsList)planarRegionsList, (Point3DReadOnly)new Point3D(0.25, 0.0, 0.0), (double)0.0, (double)heightToAvoid, (double)0.2, (double)-0.1, (double)0.1, (double)-0.1));
    }
}

