/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph.PawNode;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph.PawNodeTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class PawNodeToolsTest {
    private final Random random = new Random(456789L);
    private static final int iters = 1000;
    private final double epsilon = 1.0E-8;

    @Test
    public void testGetNodeTransform() {
        for (int i = 0; i < 1000; ++i) {
            RobotQuadrant quadrant = RobotQuadrant.generateRandomRobotQuadrant((Random)this.random);
            int frontLeftXLatticeIndex = this.random.nextInt(1000) - 500;
            int frontLeftYLatticeIndex = this.random.nextInt(1000) - 500;
            int frontRightXLatticeIndex = this.random.nextInt(1000) - 500;
            int frontRightYLatticeIndex = this.random.nextInt(1000) - 500;
            int hindLeftXLatticeIndex = this.random.nextInt(1000) - 500;
            int hindLeftYLatticeIndex = this.random.nextInt(1000) - 500;
            int hindRightXLatticeIndex = this.random.nextInt(1000) - 500;
            int hindRightYLatticeIndex = this.random.nextInt(1000) - 500;
            double frontLeftX = (double)frontLeftXLatticeIndex * PawNode.gridSizeXY;
            double frontLeftY = (double)frontLeftYLatticeIndex * PawNode.gridSizeXY;
            double frontRightX = (double)frontRightXLatticeIndex * PawNode.gridSizeXY;
            double frontRightY = (double)frontRightYLatticeIndex * PawNode.gridSizeXY;
            double hindLeftX = (double)hindLeftXLatticeIndex * PawNode.gridSizeXY;
            double hindLeftY = (double)hindLeftYLatticeIndex * PawNode.gridSizeXY;
            double hindRightX = (double)hindRightXLatticeIndex * PawNode.gridSizeXY;
            double hindRightY = (double)hindRightYLatticeIndex * PawNode.gridSizeXY;
            this.checkNodeTransform(quadrant, frontLeftX, frontLeftY, frontRightX, frontRightY, hindLeftX, hindLeftY, hindRightX, hindRightY, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.checkNodeTransform(quadrant, frontLeftX, frontLeftY, frontRightX, frontRightY, hindLeftX, hindLeftY, hindRightX, hindRightY, 0.4995 * PawNode.gridSizeXY, 0.0, 0.4995 * PawNode.gridSizeXY, 0.0, 0.4995 * PawNode.gridSizeXY, 0.0, 0.4995 * PawNode.gridSizeXY, 0.0);
            this.checkNodeTransform(quadrant, frontLeftX, frontLeftY, frontRightX, frontRightY, hindLeftX, hindLeftY, hindRightX, hindRightY, -0.4995 * PawNode.gridSizeXY, 0.0, -0.4995 * PawNode.gridSizeXY, 0.0, -0.4995 * PawNode.gridSizeXY, 0.0, -0.4995 * PawNode.gridSizeXY, 0.0);
            this.checkNodeTransform(quadrant, frontLeftX, frontLeftY, frontRightX, frontRightY, hindLeftX, hindLeftY, hindRightX, hindRightY, 0.0, 0.4995 * PawNode.gridSizeXY, 0.0, 0.4995 * PawNode.gridSizeXY, 0.0, 0.4995 * PawNode.gridSizeXY, 0.0, 0.4995 * PawNode.gridSizeXY);
            this.checkNodeTransform(quadrant, frontLeftX, frontLeftY, frontRightX, frontRightY, hindLeftX, hindLeftY, hindRightX, hindRightY, 0.0, -0.4995 * PawNode.gridSizeXY, 0.0, -0.4995 * PawNode.gridSizeXY, 0.0, -0.4995 * PawNode.gridSizeXY, 0.0, -0.4995 * PawNode.gridSizeXY);
        }
    }

    private void checkNodeTransform(RobotQuadrant quadrant, double frontLeftX, double frontLeftY, double frontRightX, double frontRightY, double hindLeftX, double hindLeftY, double hindRightX, double hindRightY, double frontLeftXOffset, double frontLeftYOffset, double frontRightXOffset, double frontRightYOffset, double hindLeftXOffset, double hindLeftYOffset, double hindRightXOffset, double hindRightYOffset) {
        double length = frontLeftX + frontLeftXOffset - hindRightX - hindRightXOffset;
        double width = frontLeftY + frontLeftYOffset - hindRightY - hindRightYOffset;
        double yaw = PawNode.computeNominalYaw((double)(frontLeftX + frontLeftXOffset), (double)(frontLeftY + frontLeftYOffset), (double)(frontRightX + frontRightXOffset), (double)(frontRightY + frontRightYOffset), (double)(hindLeftX + hindLeftXOffset), (double)(hindLeftY + hindLeftYOffset), (double)(hindRightX + hindRightXOffset), (double)(hindRightY + hindRightYOffset));
        PawNode node = new PawNode(quadrant, frontLeftX + frontLeftXOffset, frontLeftY + frontLeftYOffset, frontRightX + frontRightXOffset, frontRightY + frontRightYOffset, hindLeftX + hindLeftXOffset, hindLeftY + hindLeftYOffset, hindRightX + hindRightXOffset, hindRightY + hindRightYOffset, yaw, length, width);
        RigidBodyTransform frontLeftNodeTransform = new RigidBodyTransform();
        RigidBodyTransform frontRightNodeTransform = new RigidBodyTransform();
        RigidBodyTransform hindLeftNodeTransform = new RigidBodyTransform();
        RigidBodyTransform hindRightNodeTransform = new RigidBodyTransform();
        PawNodeTools.getNodeTransformToWorld((RobotQuadrant)RobotQuadrant.FRONT_LEFT, (PawNode)node, (RigidBodyTransform)frontLeftNodeTransform);
        PawNodeTools.getNodeTransformToWorld((RobotQuadrant)RobotQuadrant.FRONT_RIGHT, (PawNode)node, (RigidBodyTransform)frontRightNodeTransform);
        PawNodeTools.getNodeTransformToWorld((RobotQuadrant)RobotQuadrant.HIND_LEFT, (PawNode)node, (RigidBodyTransform)hindLeftNodeTransform);
        PawNodeTools.getNodeTransformToWorld((RobotQuadrant)RobotQuadrant.HIND_RIGHT, (PawNode)node, (RigidBodyTransform)hindRightNodeTransform);
        YawPitchRoll frontLeftRotationYawPitchRoll = new YawPitchRoll();
        YawPitchRoll frontRightRotationYawPitchRoll = new YawPitchRoll();
        YawPitchRoll hindLeftRotationYawPitchRoll = new YawPitchRoll();
        YawPitchRoll hindRightRotationYawPitchRoll = new YawPitchRoll();
        frontLeftRotationYawPitchRoll.set((Orientation3DReadOnly)frontLeftNodeTransform.getRotation());
        frontRightRotationYawPitchRoll.set((Orientation3DReadOnly)frontRightNodeTransform.getRotation());
        hindLeftRotationYawPitchRoll.set((Orientation3DReadOnly)hindLeftNodeTransform.getRotation());
        hindRightRotationYawPitchRoll.set((Orientation3DReadOnly)hindRightNodeTransform.getRotation());
        Assert.assertEquals((double)frontLeftNodeTransform.getTranslationX(), (double)frontLeftX, (double)1.0E-8);
        Assert.assertEquals((double)frontLeftNodeTransform.getTranslationY(), (double)frontLeftY, (double)1.0E-8);
        Assert.assertEquals((double)frontLeftNodeTransform.getTranslationZ(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)frontLeftRotationYawPitchRoll.getPitch(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)frontLeftRotationYawPitchRoll.getRoll(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)frontRightNodeTransform.getTranslationX(), (double)frontRightX, (double)1.0E-8);
        Assert.assertEquals((double)frontRightNodeTransform.getTranslationY(), (double)frontRightY, (double)1.0E-8);
        Assert.assertEquals((double)frontRightNodeTransform.getTranslationZ(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)frontRightRotationYawPitchRoll.getPitch(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)frontRightRotationYawPitchRoll.getRoll(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)hindLeftNodeTransform.getTranslationX(), (double)hindLeftX, (double)1.0E-8);
        Assert.assertEquals((double)hindLeftNodeTransform.getTranslationY(), (double)hindLeftY, (double)1.0E-8);
        Assert.assertEquals((double)hindLeftNodeTransform.getTranslationZ(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)hindLeftRotationYawPitchRoll.getPitch(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)hindLeftRotationYawPitchRoll.getRoll(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)hindRightNodeTransform.getTranslationX(), (double)hindRightX, (double)1.0E-8);
        Assert.assertEquals((double)hindRightNodeTransform.getTranslationY(), (double)hindRightY, (double)1.0E-8);
        Assert.assertEquals((double)hindRightNodeTransform.getTranslationZ(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)hindRightRotationYawPitchRoll.getPitch(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)hindRightRotationYawPitchRoll.getRoll(), (double)0.0, (double)1.0E-8);
    }

    @Test
    public void testGetSnappedNodeTransform() {
        int numTests = 10;
        for (int i = 0; i < numTests; ++i) {
            RobotQuadrant robotQuadrant = RobotQuadrant.generateRandomRobotQuadrant((Random)this.random);
            double frontLeftX = EuclidCoreRandomTools.nextDouble((Random)this.random, (double)1.0);
            double frontLeftY = EuclidCoreRandomTools.nextDouble((Random)this.random, (double)1.0);
            double frontRightX = EuclidCoreRandomTools.nextDouble((Random)this.random, (double)1.0);
            double frontRightY = EuclidCoreRandomTools.nextDouble((Random)this.random, (double)1.0);
            double hindLeftX = EuclidCoreRandomTools.nextDouble((Random)this.random, (double)1.0);
            double hindLeftY = EuclidCoreRandomTools.nextDouble((Random)this.random, (double)1.0);
            double hindRightX = EuclidCoreRandomTools.nextDouble((Random)this.random, (double)1.0);
            double hindRightY = EuclidCoreRandomTools.nextDouble((Random)this.random, (double)1.0);
            double length = frontLeftX - hindRightX;
            double width = frontLeftY - hindRightY;
            double yaw = PawNode.computeNominalYaw((double)frontLeftX, (double)frontLeftY, (double)frontRightX, (double)frontRightY, (double)hindLeftX, (double)hindLeftY, (double)hindRightX, (double)hindRightY);
            PawNode node = new PawNode(robotQuadrant, frontLeftX, frontLeftY, frontRightX, frontRightY, hindLeftX, hindLeftY, hindRightX, hindRightY, yaw, length, width);
            RigidBodyTransform frontLeftSnapTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)this.random);
            RigidBodyTransform frontRightSnapTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)this.random);
            RigidBodyTransform hindLeftSnapTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)this.random);
            RigidBodyTransform hindRightSnapTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)this.random);
            RigidBodyTransform frontLeftSnappedNodeTransform = new RigidBodyTransform();
            RigidBodyTransform frontRightSnappedNodeTransform = new RigidBodyTransform();
            RigidBodyTransform hindLeftSnappedNodeTransform = new RigidBodyTransform();
            RigidBodyTransform hindRightSnappedNodeTransform = new RigidBodyTransform();
            PawNodeTools.getSnappedNodeTransformToWorld((RobotQuadrant)RobotQuadrant.FRONT_LEFT, (PawNode)node, (RigidBodyTransform)frontLeftSnapTransform, (RigidBodyTransform)frontLeftSnappedNodeTransform);
            PawNodeTools.getSnappedNodeTransformToWorld((RobotQuadrant)RobotQuadrant.FRONT_RIGHT, (PawNode)node, (RigidBodyTransform)frontRightSnapTransform, (RigidBodyTransform)frontRightSnappedNodeTransform);
            PawNodeTools.getSnappedNodeTransformToWorld((RobotQuadrant)RobotQuadrant.HIND_LEFT, (PawNode)node, (RigidBodyTransform)hindLeftSnapTransform, (RigidBodyTransform)hindLeftSnappedNodeTransform);
            PawNodeTools.getSnappedNodeTransformToWorld((RobotQuadrant)RobotQuadrant.HIND_RIGHT, (PawNode)node, (RigidBodyTransform)hindRightSnapTransform, (RigidBodyTransform)hindRightSnappedNodeTransform);
            RigidBodyTransform frontLeftExpectedSnappedNodeTransform = new RigidBodyTransform();
            RigidBodyTransform frontRightExpectedSnappedNodeTransform = new RigidBodyTransform();
            RigidBodyTransform hindLeftExpectedSnappedNodeTransform = new RigidBodyTransform();
            RigidBodyTransform hindRightExpectedSnappedNodeTransform = new RigidBodyTransform();
            PawNodeTools.getNodeTransformToWorld((RobotQuadrant)RobotQuadrant.FRONT_LEFT, (PawNode)node, (RigidBodyTransform)frontLeftExpectedSnappedNodeTransform);
            PawNodeTools.getNodeTransformToWorld((RobotQuadrant)RobotQuadrant.FRONT_RIGHT, (PawNode)node, (RigidBodyTransform)frontRightExpectedSnappedNodeTransform);
            PawNodeTools.getNodeTransformToWorld((RobotQuadrant)RobotQuadrant.HIND_LEFT, (PawNode)node, (RigidBodyTransform)hindLeftExpectedSnappedNodeTransform);
            PawNodeTools.getNodeTransformToWorld((RobotQuadrant)RobotQuadrant.HIND_RIGHT, (PawNode)node, (RigidBodyTransform)hindRightExpectedSnappedNodeTransform);
            frontLeftSnapTransform.transform((RigidBodyTransformBasics)frontLeftExpectedSnappedNodeTransform);
            frontRightSnapTransform.transform((RigidBodyTransformBasics)frontRightExpectedSnappedNodeTransform);
            hindLeftSnapTransform.transform((RigidBodyTransformBasics)hindLeftExpectedSnappedNodeTransform);
            hindRightSnapTransform.transform((RigidBodyTransformBasics)hindRightExpectedSnappedNodeTransform);
            EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)frontLeftExpectedSnappedNodeTransform, (RigidBodyTransform)frontLeftSnappedNodeTransform, (double)1.0E-8);
            EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)frontRightExpectedSnappedNodeTransform, (RigidBodyTransform)frontRightSnappedNodeTransform, (double)1.0E-8);
            EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)hindLeftExpectedSnappedNodeTransform, (RigidBodyTransform)hindLeftSnappedNodeTransform, (double)1.0E-8);
            EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)hindRightExpectedSnappedNodeTransform, (RigidBodyTransform)hindRightSnappedNodeTransform, (double)1.0E-8);
        }
    }
}

