/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.stepStream;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.quadrupedPlanning.QuadrupedGait;
import us.ihmc.quadrupedPlanning.QuadrupedSpeed;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettings;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettingsReadOnly;
import us.ihmc.quadrupedPlanning.stepStream.QuadrupedXGaitTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class QuadrupedXGaitToolsTest {
    private static final double epsilon = 1.0E-8;
    private static final double stepDuration = 0.5;
    private static final double doubleSupportDuration = 0.2;

    @Test
    public void testManualTrot() {
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setEndPhaseShift(QuadrupedGait.TROT.getEndPhaseShift());
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        xGaitSettings.getTrotMediumTimings().setStepDuration(0.5);
        xGaitSettings.getTrotMediumTimings().setEndDoubleSupportDuration(0.2);
        Assert.assertEquals((Object)0.0, (Object)QuadrupedXGaitTools.computeTimeDeltaBetweenSteps((RobotQuadrant)RobotQuadrant.FRONT_LEFT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings));
        Assert.assertEquals((Object)0.0, (Object)QuadrupedXGaitTools.computeTimeDeltaBetweenSteps((RobotQuadrant)RobotQuadrant.FRONT_RIGHT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings));
        Assert.assertEquals((Object)0.7, (Object)QuadrupedXGaitTools.computeTimeDeltaBetweenSteps((RobotQuadrant)RobotQuadrant.HIND_RIGHT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings));
        Assert.assertEquals((Object)0.7, (Object)QuadrupedXGaitTools.computeTimeDeltaBetweenSteps((RobotQuadrant)RobotQuadrant.HIND_LEFT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings));
    }

    @Test
    public void testComputeTimeDeltaBetweenStepsPace() {
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setEndPhaseShift(QuadrupedGait.PACE.getEndPhaseShift());
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        xGaitSettings.getPaceMediumTimings().setStepDuration(0.5);
        xGaitSettings.getPaceMediumTimings().setEndDoubleSupportDuration(0.2);
        String errorMessage = "";
        errorMessage = errorMessage + this.testTimeDelta(0.7, RobotQuadrant.FRONT_LEFT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        errorMessage = errorMessage + this.testTimeDelta(0.7, RobotQuadrant.FRONT_RIGHT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        errorMessage = errorMessage + this.testTimeDelta(0.0, RobotQuadrant.HIND_RIGHT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        errorMessage = errorMessage + this.testTimeDelta(0.0, RobotQuadrant.HIND_LEFT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        Assert.assertTrue((String)errorMessage, (boolean)errorMessage.isEmpty());
    }

    @Test
    public void testComputeTimeDeltaBetweenStepsCrawl() {
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setEndPhaseShift(QuadrupedGait.AMBLE.getEndPhaseShift());
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        xGaitSettings.getAmbleMediumTimings().setStepDuration(0.5);
        xGaitSettings.getAmbleMediumTimings().setEndDoubleSupportDuration(0.2);
        String errorMessage = "";
        errorMessage = errorMessage + this.testTimeDelta(0.35, RobotQuadrant.FRONT_LEFT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        errorMessage = errorMessage + this.testTimeDelta(0.35, RobotQuadrant.FRONT_RIGHT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        errorMessage = errorMessage + this.testTimeDelta(0.35, RobotQuadrant.HIND_RIGHT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        errorMessage = errorMessage + this.testTimeDelta(0.35, RobotQuadrant.HIND_LEFT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        Assert.assertTrue((String)errorMessage, (boolean)errorMessage.isEmpty());
    }

    @Test
    public void testComputeTimeDeltaBetweenStepsTrot() {
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setEndPhaseShift(QuadrupedGait.TROT.getEndPhaseShift());
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        xGaitSettings.getTrotMediumTimings().setStepDuration(0.5);
        xGaitSettings.getTrotMediumTimings().setEndDoubleSupportDuration(0.2);
        String errorMessage = "";
        errorMessage = errorMessage + this.testTimeDelta(0.0, RobotQuadrant.FRONT_LEFT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        errorMessage = errorMessage + this.testTimeDelta(0.0, RobotQuadrant.FRONT_RIGHT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        errorMessage = errorMessage + this.testTimeDelta(0.7, RobotQuadrant.HIND_RIGHT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        errorMessage = errorMessage + this.testTimeDelta(0.7, RobotQuadrant.HIND_LEFT, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        Assert.assertTrue((String)errorMessage, (boolean)errorMessage.isEmpty());
    }

    private String testTimeDelta(double expectedDuration, RobotQuadrant robotQuadrant, QuadrupedXGaitSettingsReadOnly xGaitSettings) {
        String message = "";
        double actual = QuadrupedXGaitTools.computeTimeDeltaBetweenSteps((RobotQuadrant)robotQuadrant, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        if (!MathTools.epsilonEquals((double)expectedDuration, (double)actual, (double)1.0E-8)) {
            message = message + "\n" + robotQuadrant + " expected duration " + expectedDuration + ", got " + actual;
        }
        return message;
    }
}

