/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.concurrent.runtime.barrierScheduler.implicitContext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.BarrierSchedulerException;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.Task;

public class BarrierScheduler<C>
implements Runnable {
    private static final int BUSY_SLEEP_RESOLUTION_NS = 10000;
    private final List<? extends Task<C>> tasks;
    private final boolean[] releaseTasks;
    private final C masterContext;
    private final TaskOverrunBehavior overrunBehavior;
    private TaskExceptionHandler<C> taskExceptionHandler = TaskExceptionHandler.newDefaultTaskExceptionHandler();
    private long tick;

    public BarrierScheduler(Collection<? extends Task<C>> tasks, C masterContext, TaskOverrunBehavior overrunBehavior) {
        this.tasks = new ArrayList<Task<C>>(tasks);
        this.releaseTasks = new boolean[tasks.size()];
        this.masterContext = masterContext;
        this.overrunBehavior = overrunBehavior;
    }

    public void setTaskExceptionHandler(TaskExceptionHandler<C> taskExceptionHandler) {
        Objects.requireNonNull(taskExceptionHandler);
        this.taskExceptionHandler = taskExceptionHandler;
    }

    public void reset() {
        this.tick = 0L;
    }

    @Override
    public void run() {
        int i;
        Task<C> task;
        if (this.overrunBehavior == TaskOverrunBehavior.BUSY_WAIT) {
            while (!this.allTasksOnSchedule()) {
                try {
                    Thread.sleep(0L, 10000);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (this.overrunBehavior == TaskOverrunBehavior.SKIP_SCHEDULER_TICK) {
            for (int i2 = 0; i2 < this.tasks.size(); ++i2) {
                task = this.tasks.get(i2);
                if (!this.isTaskBehindSchedule(task)) continue;
                task.incrementDelay();
            }
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            task = this.tasks.get(i);
            this.releaseTasks[i] = task.isPending(this.tick) && task.isSleeping();
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            if (!this.releaseTasks[i]) continue;
            this.tasks.get(i).updateMasterContext(this.masterContext);
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            if (!this.releaseTasks[i]) continue;
            this.tasks.get(i).updateLocalContext(this.masterContext);
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            if (!this.releaseTasks[i] || this.tasks.get(i).release()) continue;
            throw new BarrierSchedulerException("tried to release an unwaiting task");
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            task = this.tasks.get(i);
            if (!task.hasThrownException()) continue;
            boolean restart = this.taskExceptionHandler.handleException(task, task.getThrownException());
            if (restart) {
                task.clearExceptionAndResume();
                continue;
            }
            this.shutdown();
        }
        ++this.tick;
    }

    private boolean allTasksOnSchedule() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            if (!this.isTaskBehindSchedule(this.tasks.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isTaskBehindSchedule(Task<C> task) {
        return task.isPending(this.tick) && !task.isSleeping();
    }

    public void waitUntilTasksDone() throws InterruptedException {
        int i;
        long initialTick = this.tick;
        while (true) {
            if (this.tick > initialTick) {
                throw new IllegalStateException("Cannot invoke waitUntilTasksDone while the scheduler is still running");
            }
            boolean allDone = true;
            for (int i2 = 0; i2 < this.tasks.size(); ++i2) {
                if (this.tasks.get(i2).isSleeping()) continue;
                allDone = false;
                break;
            }
            if (allDone) break;
            Thread.sleep(1L);
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            this.tasks.get(i).updateMasterContext(this.masterContext);
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            this.tasks.get(i).updateLocalContext(this.masterContext);
        }
    }

    public void shutdown() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            Task<C> task = this.tasks.get(i);
            while (!task.hasShutdown()) {
                task.requestShutdown();
            }
        }
    }

    public static interface TaskExceptionHandler<C> {
        public boolean handleException(Task<C> var1, Exception var2);

        public static <C> TaskExceptionHandler<C> newDefaultTaskExceptionHandler() {
            return (task, exception) -> {
                throw new BarrierSchedulerException("Unhandled exception:", exception);
            };
        }
    }

    public static enum TaskOverrunBehavior {
        BUSY_WAIT,
        SKIP_TICK,
        SKIP_SCHEDULER_TICK;

    }
}

