/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import us.ihmc.idl.serializers.extra.YAMLSerializer;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.CameraSettings;
import us.ihmc.robotDataLogger.CameraSettingsPubSubType;

public class CameraSettingsLoader {
    public static final String location = System.getProperty("user.home") + File.separator + ".ihmc" + File.separator + "CameraSettings.yaml";

    public static CameraSettings load() {
        File in = new File(location);
        if (in.exists()) {
            try {
                String data = new String(Files.readAllBytes(in.toPath()), Charset.defaultCharset());
                return CameraSettingsLoader.load(data);
            }
            catch (IOException e) {
                LogTools.warn((String)("Cannot load camera settings: " + e.getMessage()));
            }
        } else {
            LogTools.warn((String)("Cannot find " + location + ". No cameras available."));
        }
        return new CameraSettings();
    }

    public static CameraSettings load(String data) {
        YAMLSerializer ser = new YAMLSerializer((TopicDataType)new CameraSettingsPubSubType());
        ser.setAddTypeAsRootNode(false);
        try {
            return (CameraSettings)((Object)ser.deserialize(data));
        }
        catch (IOException e) {
            LogTools.warn((String)("Cannot load camera settings: " + e.getMessage()));
            return new CameraSettings();
        }
    }

    public static String toString(CameraSettings settings) throws IOException {
        YAMLSerializer ser = new YAMLSerializer((TopicDataType)new CameraSettingsPubSubType());
        ser.setAddTypeAsRootNode(false);
        return ser.serializeToString((Object)settings);
    }

    public static void save(CameraSettings settings) throws IOException {
        File in = new File(location);
        if (!in.getParentFile().exists()) {
            in.getParentFile().mkdirs();
        }
        Files.write(in.toPath(), CameraSettingsLoader.toString(settings).getBytes(), new OpenOption[0]);
    }
}

