/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.util.function.Supplier;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.robotDataLogger.CameraPubSubType;
import us.ihmc.robotDataLogger.LogPropertiesPubSubType;
import us.ihmc.robotDataLogger.Model;
import us.ihmc.robotDataLogger.ModelPubSubType;
import us.ihmc.robotDataLogger.Variables;
import us.ihmc.robotDataLogger.VariablesPubSubType;
import us.ihmc.robotDataLogger.Video;
import us.ihmc.robotDataLogger.VideoPubSubType;

public class LogProperties
extends Packet<LogProperties>
implements Settable<LogProperties>,
EpsilonComparable<LogProperties> {
    public StringBuilder version_ = new StringBuilder(255);
    public StringBuilder name_ = new StringBuilder(255);
    public Variables variables_ = new Variables();
    public Model model_ = new Model();
    public StringBuilder timestamp_ = new StringBuilder(255);
    public IDLSequence.Object<Camera> cameras_ = new IDLSequence.Object(255, (TopicDataType)new CameraPubSubType());
    public Video video_ = new Video();

    public LogProperties() {
    }

    public LogProperties(LogProperties other) {
        this();
        this.set(other);
    }

    public void set(LogProperties other) {
        this.version_.setLength(0);
        this.version_.append((CharSequence)other.version_);
        this.name_.setLength(0);
        this.name_.append((CharSequence)other.name_);
        VariablesPubSubType.staticCopy(other.variables_, this.variables_);
        ModelPubSubType.staticCopy(other.model_, this.model_);
        this.timestamp_.setLength(0);
        this.timestamp_.append((CharSequence)other.timestamp_);
        this.cameras_.set(other.cameras_);
        VideoPubSubType.staticCopy(other.video_, this.video_);
    }

    public void setVersion(String version) {
        this.version_.setLength(0);
        this.version_.append(version);
    }

    public String getVersionAsString() {
        return this.getVersion().toString();
    }

    public StringBuilder getVersion() {
        return this.version_;
    }

    public void setName(String name) {
        this.name_.setLength(0);
        this.name_.append(name);
    }

    public String getNameAsString() {
        return this.getName().toString();
    }

    public StringBuilder getName() {
        return this.name_;
    }

    public Variables getVariables() {
        return this.variables_;
    }

    public Model getModel() {
        return this.model_;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp_.setLength(0);
        this.timestamp_.append(timestamp);
    }

    public String getTimestampAsString() {
        return this.getTimestamp().toString();
    }

    public StringBuilder getTimestamp() {
        return this.timestamp_;
    }

    public IDLSequence.Object<Camera> getCameras() {
        return this.cameras_;
    }

    public Video getVideo() {
        return this.video_;
    }

    public static Supplier<LogPropertiesPubSubType> getPubSubType() {
        return LogPropertiesPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return LogPropertiesPubSubType::new;
    }

    public boolean epsilonEquals(LogProperties other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.version_, (StringBuilder)other.version_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.name_, (StringBuilder)other.name_, (double)epsilon)) {
            return false;
        }
        if (!this.variables_.epsilonEquals(other.variables_, epsilon)) {
            return false;
        }
        if (!this.model_.epsilonEquals(other.model_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.timestamp_, (StringBuilder)other.timestamp_, (double)epsilon)) {
            return false;
        }
        if (this.cameras_.size() != other.cameras_.size()) {
            return false;
        }
        for (int i = 0; i < this.cameras_.size(); ++i) {
            if (((Camera)((Object)this.cameras_.get(i))).epsilonEquals((Camera)((Object)other.cameras_.get(i)), epsilon)) continue;
            return false;
        }
        return this.video_.epsilonEquals(other.video_, epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof LogProperties)) {
            return false;
        }
        LogProperties otherMyClass = (LogProperties)((Object)other);
        if (!IDLTools.equals((StringBuilder)this.version_, (StringBuilder)otherMyClass.version_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.name_, (StringBuilder)otherMyClass.name_)) {
            return false;
        }
        if (!this.variables_.equals((Object)otherMyClass.variables_)) {
            return false;
        }
        if (!this.model_.equals((Object)otherMyClass.model_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.timestamp_, (StringBuilder)otherMyClass.timestamp_)) {
            return false;
        }
        if (!this.cameras_.equals(otherMyClass.cameras_)) {
            return false;
        }
        return this.video_.equals((Object)otherMyClass.video_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LogProperties {");
        builder.append("version=");
        builder.append((CharSequence)this.version_);
        builder.append(", ");
        builder.append("name=");
        builder.append((CharSequence)this.name_);
        builder.append(", ");
        builder.append("variables=");
        builder.append((Object)this.variables_);
        builder.append(", ");
        builder.append("model=");
        builder.append((Object)this.model_);
        builder.append(", ");
        builder.append("timestamp=");
        builder.append((CharSequence)this.timestamp_);
        builder.append(", ");
        builder.append("cameras=");
        builder.append(this.cameras_);
        builder.append(", ");
        builder.append("video=");
        builder.append((Object)this.video_);
        builder.append("}");
        return builder.toString();
    }
}

