/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.ReferenceFrameInformation;

public class ReferenceFrameInformationPubSubType
implements TopicDataType<ReferenceFrameInformation> {
    public static final String name = "us::ihmc::robotDataLogger::ReferenceFrameInformation";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "47788074ef85fc4d41967bc5006da101900e00ccaa28e8af31c5da7ecd907d3e";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(ReferenceFrameInformation data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        ReferenceFrameInformationPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, ReferenceFrameInformation data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        ReferenceFrameInformationPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return ReferenceFrameInformationPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 32768 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 8192; ++i0) {
            current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(ReferenceFrameInformation data) {
        return ReferenceFrameInformationPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(ReferenceFrameInformation data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getFrameIndices().size() * 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getFrameNames().size(); ++i0) {
            current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + ((StringBuilder)data.getFrameNames().get(i0)).length() + 1;
        }
        return current_alignment - initial_alignment;
    }

    public static void write(ReferenceFrameInformation data, CDR cdr) {
        if (data.getFrameIndices().size() > 8192) {
            throw new RuntimeException("frameIndices field exceeds the maximum length: %d > %d".formatted(data.getFrameIndices().size(), 8192));
        }
        cdr.write_type_e((IDLSequence)data.getFrameIndices());
        if (data.getFrameNames().size() > 8192) {
            throw new RuntimeException("frameNames field exceeds the maximum length: %d > %d".formatted(data.getFrameNames().size(), 8192));
        }
        cdr.write_type_e((IDLSequence)data.getFrameNames());
    }

    public static void read(ReferenceFrameInformation data, CDR cdr) {
        cdr.read_type_e((IDLSequence)data.getFrameIndices());
        cdr.read_type_e((IDLSequence)data.getFrameNames());
    }

    public final void serialize(ReferenceFrameInformation data, InterchangeSerializer ser) {
        ser.write_type_e("frameIndices", (IDLSequence)data.getFrameIndices());
        ser.write_type_e("frameNames", (IDLSequence)data.getFrameNames());
    }

    public final void deserialize(InterchangeSerializer ser, ReferenceFrameInformation data) {
        ser.read_type_e("frameIndices", (IDLSequence)data.getFrameIndices());
        ser.read_type_e("frameNames", (IDLSequence)data.getFrameNames());
    }

    public static void staticCopy(ReferenceFrameInformation src, ReferenceFrameInformation dest) {
        dest.set(src);
    }

    public ReferenceFrameInformation createData() {
        return new ReferenceFrameInformation();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)ReferenceFrameInformationPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(ReferenceFrameInformation data, CDR cdr) {
        ReferenceFrameInformationPubSubType.write(data, cdr);
    }

    public void deserialize(ReferenceFrameInformation data, CDR cdr) {
        ReferenceFrameInformationPubSubType.read(data, cdr);
    }

    public void copy(ReferenceFrameInformation src, ReferenceFrameInformation dest) {
        ReferenceFrameInformationPubSubType.staticCopy(src, dest);
    }

    public ReferenceFrameInformationPubSubType newInstance() {
        return new ReferenceFrameInformationPubSubType();
    }
}

