/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.Summary;

public class SummaryPubSubType
implements TopicDataType<Summary> {
    public static final String name = "us::ihmc::robotDataLogger::Summary";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "47788074ef85fc4d41967bc5006da101900e00ccaa28e8af31c5da7ecd907d3e";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(Summary data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        SummaryPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Summary data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        SummaryPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return SummaryPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 1024 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 128; ++i0) {
            current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 1024 + 1;
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Summary data) {
        return SummaryPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Summary data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getSummaryTriggerVariable().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getSummarizedVariables().size(); ++i0) {
            current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + ((StringBuilder)data.getSummarizedVariables().get(i0)).length() + 1;
        }
        return current_alignment - initial_alignment;
    }

    public static void write(Summary data, CDR cdr) {
        cdr.write_type_7(data.getCreateSummary());
        if (data.getSummaryTriggerVariable().length() > 1024) {
            throw new RuntimeException("summaryTriggerVariable field exceeds the maximum length: %d > %d".formatted(data.getSummaryTriggerVariable().length(), 1024));
        }
        cdr.write_type_d(data.getSummaryTriggerVariable());
        if (data.getSummarizedVariables().size() > 128) {
            throw new RuntimeException("summarizedVariables field exceeds the maximum length: %d > %d".formatted(data.getSummarizedVariables().size(), 128));
        }
        cdr.write_type_e((IDLSequence)data.getSummarizedVariables());
    }

    public static void read(Summary data, CDR cdr) {
        data.setCreateSummary(cdr.read_type_7());
        cdr.read_type_d(data.getSummaryTriggerVariable());
        cdr.read_type_e((IDLSequence)data.getSummarizedVariables());
    }

    public final void serialize(Summary data, InterchangeSerializer ser) {
        ser.write_type_7("createSummary", data.getCreateSummary());
        ser.write_type_d("summaryTriggerVariable", data.getSummaryTriggerVariable());
        ser.write_type_e("summarizedVariables", (IDLSequence)data.getSummarizedVariables());
    }

    public final void deserialize(InterchangeSerializer ser, Summary data) {
        data.setCreateSummary(ser.read_type_7("createSummary"));
        ser.read_type_d("summaryTriggerVariable", data.getSummaryTriggerVariable());
        ser.read_type_e("summarizedVariables", (IDLSequence)data.getSummarizedVariables());
    }

    public static void staticCopy(Summary src, Summary dest) {
        dest.set(src);
    }

    public Summary createData() {
        return new Summary();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)SummaryPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Summary data, CDR cdr) {
        SummaryPubSubType.write(data, cdr);
    }

    public void deserialize(Summary data, CDR cdr) {
        SummaryPubSubType.read(data, cdr);
    }

    public void copy(Summary src, Summary dest) {
        SummaryPubSubType.staticCopy(src, dest);
    }

    public SummaryPubSubType newInstance() {
        return new SummaryPubSubType();
    }
}

