/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.YoRegistryDefinition;

public class YoRegistryDefinitionPubSubType
implements TopicDataType<YoRegistryDefinition> {
    public static final String name = "us::ihmc::robotDataLogger::YoRegistryDefinition";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "47788074ef85fc4d41967bc5006da101900e00ccaa28e8af31c5da7ecd907d3e";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(YoRegistryDefinition data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        YoRegistryDefinitionPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, YoRegistryDefinition data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        YoRegistryDefinitionPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return YoRegistryDefinitionPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 2 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(YoRegistryDefinition data) {
        return YoRegistryDefinitionPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(YoRegistryDefinition data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 2 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        return current_alignment - initial_alignment;
    }

    public static void write(YoRegistryDefinition data, CDR cdr) {
        cdr.write_type_3(data.getParent());
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length: %d > %d".formatted(data.getName().length(), 255));
        }
        cdr.write_type_d(data.getName());
    }

    public static void read(YoRegistryDefinition data, CDR cdr) {
        data.setParent(cdr.read_type_3());
        cdr.read_type_d(data.getName());
    }

    public final void serialize(YoRegistryDefinition data, InterchangeSerializer ser) {
        ser.write_type_3("parent", data.getParent());
        ser.write_type_d("name", data.getName());
    }

    public final void deserialize(InterchangeSerializer ser, YoRegistryDefinition data) {
        data.setParent(ser.read_type_3("parent"));
        ser.read_type_d("name", data.getName());
    }

    public static void staticCopy(YoRegistryDefinition src, YoRegistryDefinition dest) {
        dest.set(src);
    }

    public YoRegistryDefinition createData() {
        return new YoRegistryDefinition();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)YoRegistryDefinitionPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(YoRegistryDefinition data, CDR cdr) {
        YoRegistryDefinitionPubSubType.write(data, cdr);
    }

    public void deserialize(YoRegistryDefinition data, CDR cdr) {
        YoRegistryDefinitionPubSubType.read(data, cdr);
    }

    public void copy(YoRegistryDefinition src, YoRegistryDefinition dest) {
        YoRegistryDefinitionPubSubType.staticCopy(src, dest);
    }

    public YoRegistryDefinitionPubSubType newInstance() {
        return new YoRegistryDefinitionPubSubType();
    }
}

