/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.dataBuffers;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import java.util.List;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.dataBuffers.RegistryReceiveBuffer;
import us.ihmc.robotDataLogger.interfaces.VariableChangedProducer;
import us.ihmc.robotDataLogger.jointState.JointState;
import us.ihmc.tools.compression.CompressionImplementation;
import us.ihmc.tools.compression.CompressionImplementationFactory;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoVariable;

public class RegistryDecompressor {
    private final List<YoVariable> variables;
    private final List<JointState> jointStates;
    private final ByteBuffer decompressBuffer;
    private final CompressionImplementation compressionImplementation;
    private Object variableSynchronizer = null;

    public RegistryDecompressor(List<YoVariable> variables, List<JointState> jointStates) {
        this.variables = variables;
        this.jointStates = jointStates;
        this.decompressBuffer = ByteBuffer.allocate(variables.size() * 8);
        this.compressionImplementation = CompressionImplementationFactory.instance();
    }

    private void setAndNotify(YoVariable variable, long newValue) {
        List changedListeners;
        long previousValue = variable.getValueAsLongBits();
        variable.setValueFromLongBits(newValue, false);
        if (previousValue != newValue && (changedListeners = variable.getListeners()) != null) {
            for (int listener = 0; listener < changedListeners.size(); ++listener) {
                YoVariableChangedListener changedListener = (YoVariableChangedListener)changedListeners.get(listener);
                if (changedListener instanceof VariableChangedProducer.VariableListener) continue;
                changedListener.changed(variable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompressSegment(RegistryReceiveBuffer buffer, int registryOffset) {
        this.decompressBuffer.clear();
        try {
            this.compressionImplementation.decompress(buffer.getData(), this.decompressBuffer, buffer.getNumberOfVariables() * 8);
        }
        catch (Throwable e) {
            LogTools.error((String)("Cannot decompress incoming packet. Skipping packet. " + e.getMessage()));
            return;
        }
        this.decompressBuffer.flip();
        LongBuffer longData = this.decompressBuffer.asLongBuffer();
        if (longData.remaining() != buffer.getNumberOfVariables()) {
            LogTools.error((String)"Number of variables in incoming message does not match stated number of variables. Skipping packet.");
            return;
        }
        int numberOfVariables = buffer.getNumberOfVariables();
        if (this.variableSynchronizer != null) {
            Object object = this.variableSynchronizer;
            synchronized (object) {
                this.updateVariables(buffer, registryOffset, longData, numberOfVariables);
            }
        } else {
            this.updateVariables(buffer, registryOffset, longData, numberOfVariables);
        }
    }

    private void updateVariables(RegistryReceiveBuffer buffer, int registryOffset, LongBuffer longData, int numberOfVariables) {
        int offset = registryOffset;
        for (int i = 0; i < numberOfVariables; ++i) {
            this.setAndNotify(this.variables.get(i + offset), longData.get());
        }
        double[] jointStateArray = buffer.getJointStates();
        if (jointStateArray.length > 0) {
            DoubleBuffer jointStateBuffer = DoubleBuffer.wrap(jointStateArray);
            for (int i = 0; i < this.jointStates.size(); ++i) {
                this.jointStates.get(i).update(jointStateBuffer);
            }
        }
    }

    public void setVariableSynchronizer(Object variableSynchronizer) {
        this.variableSynchronizer = variableSynchronizer;
    }
}

