/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import com.google.common.io.Files;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import us.ihmc.robotDataLogger.LogIndex;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.tools.compression.SnappyUtils;

public class YoVariableLogReader {
    private boolean initialized = false;
    protected final File logDirectory;
    protected final LogProperties logProperties;
    private int logLineLength;
    private int numberOfEntries;
    protected final File handshake;
    private FileChannel logChannel;
    private LogIndex logIndex;
    private ByteBuffer compressedData;
    private ByteBuffer uncompressedData;
    private FileInputStream logInputStream;
    protected final File properties;
    private final File model;
    private final File resourceBundle;
    private final File summary;

    public YoVariableLogReader(File logDirectory, LogProperties logProperties) {
        this.logDirectory = logDirectory;
        this.logProperties = logProperties;
        this.properties = new File(logDirectory, "robotData.log");
        this.model = !logProperties.getModel().getPathAsString().isEmpty() ? new File(logDirectory, logProperties.getModel().getPathAsString()) : null;
        this.resourceBundle = !logProperties.getModel().getResourceBundleAsString().isEmpty() ? new File(logDirectory, logProperties.getModel().getResourceBundleAsString()) : null;
        this.summary = !logProperties.getVariables().getSummaryAsString().isEmpty() ? new File(logDirectory, logProperties.getVariables().getSummaryAsString()) : null;
        this.handshake = new File(logDirectory, logProperties.getVariables().getHandshakeAsString());
        if (!this.handshake.exists()) {
            throw new RuntimeException("Cannot find " + logProperties.getVariables().getHandshakeAsString());
        }
    }

    protected boolean initialize() {
        if (!this.initialized) {
            try {
                DataInputStream handshakeStream = new DataInputStream(new FileInputStream(this.handshake));
                byte[] handshakeData = new byte[(int)this.handshake.length()];
                handshakeStream.readFully(handshakeData);
                handshakeStream.close();
                this.logLineLength = YoVariableHandshakeParser.getNumberOfStateVariables(this.logProperties.getVariables().getHandshakeFileType(), handshakeData);
                File logdata = new File(this.logDirectory, this.logProperties.getVariables().getDataAsString());
                if (!logdata.exists()) {
                    throw new RuntimeException("Cannot find " + this.logProperties.getVariables().getDataAsString());
                }
                File index = new File(this.logDirectory, this.logProperties.getVariables().getIndexAsString());
                if (!index.exists()) {
                    throw new RuntimeException("Cannot find " + this.logProperties.getVariables().getIndexAsString());
                }
                this.logInputStream = new FileInputStream(logdata);
                this.logChannel = this.logInputStream.getChannel();
                this.logIndex = new LogIndex(index, this.logChannel.size());
                int bufferSize = this.logLineLength * 8;
                this.compressedData = ByteBuffer.allocate(SnappyUtils.maxCompressedLength(bufferSize));
                this.uncompressedData = ByteBuffer.allocate(bufferSize);
                this.numberOfEntries = this.logIndex.getNumberOfEntries();
                this.initialized = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.initialized;
    }

    public int getNumberOfVariables() {
        return this.logLineLength;
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public void close() {
        try {
            this.logChannel.close();
            this.logInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int getPosition(long timestamp) throws IOException {
        return this.logIndex.seek(timestamp);
    }

    protected long getDataOffset(int position) {
        return this.logIndex.dataOffsets[position];
    }

    protected int getCompressedSize(int position) {
        return this.logIndex.compressedSizes[position];
    }

    protected long getTimestamp(int position) {
        return this.logIndex.timestamps[position];
    }

    protected ByteBuffer readCompressedData(int position) throws IOException {
        int size = this.getCompressedSize(position);
        long startOffset = this.getDataOffset(position);
        this.logChannel.position(startOffset);
        this.compressedData.clear();
        this.compressedData.limit(size);
        this.logChannel.read(this.compressedData);
        this.compressedData.flip();
        return this.compressedData;
    }

    protected ByteBuffer readData(int position) throws IOException {
        ByteBuffer compressedData = this.readCompressedData(position);
        this.uncompressedData.clear();
        SnappyUtils.uncompress(compressedData, this.uncompressedData);
        this.uncompressedData.flip();
        return this.uncompressedData;
    }

    protected void copyMetaData(File destination) throws IOException {
        File propertiesDestination = new File(destination, "robotData.log");
        Files.copy((File)this.properties, (File)propertiesDestination);
        File handShakeDestination = new File(destination, this.logProperties.getVariables().getHandshakeAsString());
        Files.copy((File)this.handshake, (File)handShakeDestination);
        if (this.model != null) {
            File modelDesitination = new File(destination, this.logProperties.getModel().getPathAsString());
            Files.copy((File)this.model, (File)modelDesitination);
        }
        if (this.resourceBundle != null) {
            File resourceDestination = new File(destination, this.logProperties.getModel().getResourceBundleAsString());
            Files.copy((File)this.resourceBundle, (File)resourceDestination);
        }
        if (this.summary != null) {
            File summaryDestination = new File(destination, this.logProperties.getVariables().getSummaryAsString());
            Files.copy((File)this.summary, (File)summaryDestination);
        }
    }
}

